/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.connectors.pulsar.internal.ClosableBlockingQueue;
import org.apache.flink.streaming.connectors.pulsar.internal.ExceptionProxy;
import org.apache.flink.streaming.connectors.pulsar.internal.PoisonState;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarCommitCallback;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarMetadataReader;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicPartitionStateWithWatermarkGenerator;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicState;
import org.apache.flink.streaming.connectors.pulsar.internal.ReaderThread;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceContextWatermarkOutputAdapter;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceSinkUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.util.serialization.PulsarDeserializationSchema;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarFetcher<T> {
    private static final Logger log = LoggerFactory.getLogger(PulsarFetcher.class);
    private static final int NO_TIMESTAMPS_WATERMARKS = 0;
    private static final int WITH_WATERMARK_GENERATOR = 1;
    protected final SourceFunction.SourceContext<T> sourceContext;
    protected final Map<TopicRange, MessageId> seedTopicsWithInitialOffsets;
    protected final Set<TopicRange> excludeStartMessageIds;
    private final Object checkpointLock;
    protected final List<PulsarTopicState<T>> subscribedPartitionStates;
    protected final ClosableBlockingQueue<PulsarTopicState<T>> unassignedPartitionsQueue;
    private final int timestampWatermarkMode;
    private final SerializedValue<WatermarkStrategy<T>> watermarkStrategy;
    private final ClassLoader userCodeClassLoader;
    private final StreamingRuntimeContext runtimeContext;
    protected final ClientConfigurationData clientConf;
    protected final Map<String, Object> readerConf;
    protected final PulsarDeserializationSchema<T> deserializer;
    protected final int pollTimeoutMs;
    private final int commitMaxRetries;
    protected final PulsarMetadataReader metadataReader;
    protected final WatermarkOutput watermarkOutput;
    private final WatermarkOutputMultiplexer watermarkOutputMultiplexer;
    private volatile boolean running = true;
    private Map<TopicRange, ReaderThread<T>> topicToThread;
    private boolean failOnDataLoss = true;
    private boolean useEarliestWhenDataLoss;
    private final boolean useMetrics;
    private final MetricGroup consumerMetricGroup;

    public PulsarFetcher(SourceFunction.SourceContext<T> sourceContext, Map<TopicRange, MessageId> seedTopicsWithInitialOffsets, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, StreamingRuntimeContext runtimeContext, ClientConfigurationData clientConf, Map<String, Object> readerConf, int pollTimeoutMs, PulsarDeserializationSchema<T> deserializer, PulsarMetadataReader metadataReader, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        this(sourceContext, seedTopicsWithInitialOffsets, Collections.emptySet(), watermarkStrategy, processingTimeProvider, autoWatermarkInterval, userCodeClassLoader, runtimeContext, clientConf, readerConf, pollTimeoutMs, 3, deserializer, metadataReader, consumerMetricGroup, useMetrics);
    }

    public PulsarFetcher(SourceFunction.SourceContext<T> sourceContext, Map<TopicRange, MessageId> seedTopicsWithInitialOffsets, Set<TopicRange> excludeStartMessageIds, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, StreamingRuntimeContext runtimeContext, ClientConfigurationData clientConf, Map<String, Object> readerConf, int pollTimeoutMs, int commitMaxRetries, PulsarDeserializationSchema<T> deserializer, PulsarMetadataReader metadataReader, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        this.sourceContext = sourceContext;
        this.watermarkOutput = new SourceContextWatermarkOutputAdapter<T>(sourceContext);
        this.watermarkOutputMultiplexer = new WatermarkOutputMultiplexer(this.watermarkOutput);
        this.useMetrics = useMetrics;
        this.consumerMetricGroup = (MetricGroup)Preconditions.checkNotNull((Object)consumerMetricGroup);
        this.seedTopicsWithInitialOffsets = seedTopicsWithInitialOffsets;
        this.excludeStartMessageIds = excludeStartMessageIds;
        this.checkpointLock = sourceContext.getCheckpointLock();
        this.userCodeClassLoader = userCodeClassLoader;
        this.runtimeContext = runtimeContext;
        this.clientConf = clientConf;
        this.readerConf = readerConf == null ? new HashMap() : readerConf;
        this.failOnDataLoss = SourceSinkUtils.getFailOnDataLossAndRemoveKey(this.readerConf);
        this.useEarliestWhenDataLoss = SourceSinkUtils.getUseEarliestWhenDataLossAndRemoveKey(this.readerConf);
        this.pollTimeoutMs = pollTimeoutMs;
        this.commitMaxRetries = commitMaxRetries;
        this.deserializer = deserializer;
        this.metadataReader = metadataReader;
        this.watermarkStrategy = watermarkStrategy;
        this.timestampWatermarkMode = watermarkStrategy == null ? 0 : 1;
        this.unassignedPartitionsQueue = new ClosableBlockingQueue();
        this.subscribedPartitionStates = this.createPartitionStateHolders(seedTopicsWithInitialOffsets, this.timestampWatermarkMode, watermarkStrategy, userCodeClassLoader);
        for (PulsarTopicState<T> state : this.subscribedPartitionStates) {
            if (state.isOffsetDefined()) continue;
            throw new IllegalArgumentException("The fetcher was assigned seed partitions with undefined initial offsets.");
        }
        for (PulsarTopicState<T> state : this.subscribedPartitionStates) {
            this.unassignedPartitionsQueue.add(state);
        }
        if (useMetrics) {
            this.registerOffsetMetrics(consumerMetricGroup, this.subscribedPartitionStates);
        }
        if (this.timestampWatermarkMode == 1 && autoWatermarkInterval > 0L) {
            PeriodicWatermarkEmitter<T> periodicEmitter = new PeriodicWatermarkEmitter<T>(this.checkpointLock, this.subscribedPartitionStates, this.watermarkOutputMultiplexer, processingTimeProvider, autoWatermarkInterval);
            periodicEmitter.start();
        }
    }

    public void runFetchLoop() throws Exception {
        this.topicToThread = new HashMap<TopicRange, ReaderThread<T>>();
        ExceptionProxy exceptionProxy = new ExceptionProxy(Thread.currentThread());
        try {
            while (this.running) {
                exceptionProxy.checkAndThrowException();
                List<PulsarTopicState<T>> topicsToAssign = this.unassignedPartitionsQueue.getBatchBlocking(5000L);
                topicsToAssign.removeIf(s -> s.equals(PoisonState.INSTANCE));
                if (!topicsToAssign.isEmpty()) {
                    if (!this.running) {
                        throw BreakingException.INSTANCE;
                    }
                    this.topicToThread.putAll(this.createAndStartReaderThread(topicsToAssign, exceptionProxy));
                } else {
                    this.topicToThread.values().removeIf(t -> !t.isRunning());
                }
                if (this.topicToThread.size() != 0 || !this.unassignedPartitionsQueue.isEmpty()) continue;
                PulsarTopicState<T> topicForBlocking = this.unassignedPartitionsQueue.getElementBlocking();
                if (topicForBlocking.equals(PoisonState.INSTANCE)) {
                    throw BreakingException.INSTANCE;
                }
                this.topicToThread.putAll(this.createAndStartReaderThread((List<PulsarTopicState<T>>)ImmutableList.of(topicForBlocking), exceptionProxy));
            }
        }
        catch (BreakingException t2) {
        }
        catch (InterruptedException e) {
            exceptionProxy.checkAndThrowException();
            throw e;
        }
        finally {
            this.running = false;
            Thread.interrupted();
            try {
                int runningThreads = 0;
                do {
                    runningThreads = 0;
                    this.topicToThread.values().removeIf(s -> !s.isAlive());
                    for (ReaderThread<T> t3 : this.topicToThread.values()) {
                        t3.cancel();
                        ++runningThreads;
                    }
                    if (runningThreads <= 0) continue;
                    for (ReaderThread<T> t3 : this.topicToThread.values()) {
                        t3.join(500 / runningThreads + 1);
                    }
                } while (runningThreads > 0);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t4) {
                log.error("Exception while shutting down reader threads", t4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitRecordsWithTimestamps(T record, PulsarTopicState<T> partitionState, MessageId offset, long pulsarEventTimestamp) {
        Object object = this.checkpointLock;
        synchronized (object) {
            if (record != null) {
                long timestamp = partitionState.extractTimestamp(record, pulsarEventTimestamp);
                this.sourceContext.collectWithTimestamp(record, timestamp);
                partitionState.onEvent(record, timestamp);
            }
            partitionState.setOffset(offset);
        }
    }

    public void cancel() throws Exception {
        this.running = false;
        Set<TopicRange> topics = this.subscribedPartitionStates.stream().map(PulsarTopicState::getTopicRange).collect(Collectors.toSet());
        try {
            this.metadataReader.removeCursor(topics);
        }
        catch (PulsarMetadataReader.ClosedException closedException) {
        }
        catch (Exception e) {
            throw e;
        }
        this.unassignedPartitionsQueue.addIfOpen(PoisonState.INSTANCE);
    }

    public void commitOffsetToPulsar(Map<TopicRange, MessageId> offset, PulsarCommitCallback offsetCommitCallback) throws InterruptedException {
        this.doCommitOffsetToPulsar(this.removeEarliestAndLatest(offset), offsetCommitCallback);
    }

    protected void doCommitOffsetToPulsar(Map<TopicRange, MessageId> offset, PulsarCommitCallback offsetCommitCallback) throws InterruptedException {
        try {
            int retries = 0;
            boolean success = false;
            while (this.running) {
                try {
                    this.metadataReader.commitOffsetToCursor(offset);
                    success = true;
                    break;
                }
                catch (Exception e) {
                    log.warn("Failed to commit cursor to Pulsar.", (Throwable)e);
                    if (retries >= this.commitMaxRetries) {
                        log.error("Failed to commit cursor to Pulsar after {} attempts", (Object)retries);
                        throw e;
                    }
                    ++retries;
                    Thread.sleep(1000L);
                }
            }
            if (!success) {
                return;
            }
            offsetCommitCallback.onSuccess();
        }
        catch (Exception e) {
            if (this.running) {
                offsetCommitCallback.onException(e);
            }
            return;
        }
        for (PulsarTopicState<T> state : this.subscribedPartitionStates) {
            MessageId off = offset.get(state.getTopicRange());
            if (off == null) continue;
            state.setCommittedOffset(off);
        }
    }

    public Map<TopicRange, MessageId> removeEarliestAndLatest(Map<TopicRange, MessageId> offset) {
        HashMap<TopicRange, MessageId> result = new HashMap<TopicRange, MessageId>();
        for (Map.Entry<TopicRange, MessageId> entry : offset.entrySet()) {
            MessageId mid = entry.getValue();
            if (mid.equals(MessageId.earliest) || mid.equals(MessageId.latest)) continue;
            result.put(entry.getKey(), mid);
        }
        return result;
    }

    public void addDiscoveredTopics(Set<TopicRange> newTopics) throws IOException, ClassNotFoundException {
        List<PulsarTopicState<T>> newStates = this.createPartitionStateHolders(newTopics.stream().collect(Collectors.toMap(t -> t, t -> MessageId.earliest)), this.timestampWatermarkMode, this.watermarkStrategy, this.userCodeClassLoader);
        for (PulsarTopicState<T> state : newStates) {
            this.subscribedPartitionStates.add(state);
            this.unassignedPartitionsQueue.add(state);
        }
    }

    public Map<TopicRange, MessageId> snapshotCurrentState() {
        assert (Thread.holdsLock(this.checkpointLock));
        HashMap<TopicRange, MessageId> state = new HashMap<TopicRange, MessageId>(this.subscribedPartitionStates.size());
        for (PulsarTopicState<T> pa : this.subscribedPartitionStates) {
            state.put(pa.getTopicRange(), pa.getOffset());
        }
        return state;
    }

    public Map<TopicRange, ReaderThread<T>> createAndStartReaderThread(List<PulsarTopicState<T>> states, ExceptionProxy exceptionProxy) {
        Map<TopicRange, MessageId> startingOffsets = states.stream().collect(Collectors.toMap(PulsarTopicState::getTopicRange, PulsarTopicState::getOffset));
        this.metadataReader.setupCursor(startingOffsets, this.failOnDataLoss);
        HashMap<TopicRange, ReaderThread<T>> topic2Threads = new HashMap<TopicRange, ReaderThread<T>>();
        for (PulsarTopicState<T> state : states) {
            ReaderThread<T> readerT = this.createReaderThread(exceptionProxy, state);
            readerT.setName(String.format("Pulsar Reader for %s in task %s", state.getTopicRange(), this.runtimeContext.getTaskName()));
            readerT.setDaemon(true);
            readerT.start();
            log.info("Starting Thread {}", (Object)readerT.getName());
            topic2Threads.put(state.getTopicRange(), readerT);
        }
        return topic2Threads;
    }

    protected List<PulsarTopicState<T>> getSubscribedTopicStates() {
        return this.subscribedPartitionStates;
    }

    protected ReaderThread<T> createReaderThread(ExceptionProxy exceptionProxy, PulsarTopicState state) {
        return new ReaderThread<T>(this, state, this.clientConf, this.readerConf, this.deserializer, this.pollTimeoutMs, exceptionProxy, this.failOnDataLoss, this.useEarliestWhenDataLoss, this.excludeStartMessageIds.contains(state.getTopicRange()));
    }

    private List<PulsarTopicState<T>> createPartitionStateHolders(Map<TopicRange, MessageId> partitionsToInitialOffsets, int timestampWatermarkMode, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ClassLoader userCodeClassLoader) throws IOException, ClassNotFoundException {
        CopyOnWriteArrayList<PulsarTopicState<T>> partitionStates = new CopyOnWriteArrayList<PulsarTopicState<T>>();
        switch (timestampWatermarkMode) {
            case 0: {
                for (Map.Entry<TopicRange, MessageId> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    PulsarTopicState state = new PulsarTopicState(partitionEntry.getKey());
                    state.setOffset(partitionEntry.getValue());
                    partitionStates.add(state);
                }
                return partitionStates;
            }
            case 1: {
                for (Map.Entry<TopicRange, MessageId> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    TopicRange topicRange = partitionEntry.getKey();
                    PulsarTopicState state = new PulsarTopicState(partitionEntry.getKey());
                    WatermarkStrategy deserializedWatermarkStrategy = (WatermarkStrategy)watermarkStrategy.deserializeValue(userCodeClassLoader);
                    String partitionId = state.getTopicRange().toString();
                    this.watermarkOutputMultiplexer.registerNewOutput(partitionId);
                    WatermarkOutput immediateOutput = this.watermarkOutputMultiplexer.getImmediateOutput(partitionId);
                    WatermarkOutput deferredOutput = this.watermarkOutputMultiplexer.getDeferredOutput(partitionId);
                    PulsarTopicPartitionStateWithWatermarkGenerator partitionState = new PulsarTopicPartitionStateWithWatermarkGenerator(topicRange, state, deserializedWatermarkStrategy.createTimestampAssigner(() -> this.consumerMetricGroup), deserializedWatermarkStrategy.createWatermarkGenerator(() -> this.consumerMetricGroup), immediateOutput, deferredOutput);
                    partitionState.setOffset(partitionEntry.getValue());
                    partitionStates.add(partitionState);
                }
                return partitionStates;
            }
        }
        throw new RuntimeException();
    }

    private void registerOffsetMetrics(MetricGroup consumerMetricGroup, List<PulsarTopicState<T>> partitionOffsetStates) {
        for (PulsarTopicState<T> pts : partitionOffsetStates) {
            MetricGroup topicPartitionGroup = consumerMetricGroup.addGroup("topic", pts.getTopicRange().getTopic());
            topicPartitionGroup.gauge("currentOffsets", (Gauge)new OffsetGauge(pts, OffsetGaugeType.CURRENT_OFFSET));
            topicPartitionGroup.gauge("committedOffsets", (Gauge)new OffsetGauge(pts, OffsetGaugeType.COMMITTED_OFFSET));
        }
    }

    public PulsarMetadataReader getMetaDataReader() {
        return this.metadataReader;
    }

    private static class BreakingException
    extends Exception {
        static final BreakingException INSTANCE = new BreakingException();

        private BreakingException() {
        }
    }

    private static class PeriodicWatermarkEmitter<T>
    implements ProcessingTimeCallback {
        private final Object checkpointLock;
        private final List<PulsarTopicState<T>> allPartitions;
        private final WatermarkOutputMultiplexer watermarkOutputMultiplexer;
        private final ProcessingTimeService timerService;
        private final long interval;

        PeriodicWatermarkEmitter(Object checkpointLock, List<PulsarTopicState<T>> allPartitions, WatermarkOutputMultiplexer watermarkOutputMultiplexer, ProcessingTimeService timerService, long autoWatermarkInterval) {
            this.checkpointLock = checkpointLock;
            this.allPartitions = (List)Preconditions.checkNotNull(allPartitions);
            this.watermarkOutputMultiplexer = watermarkOutputMultiplexer;
            this.timerService = (ProcessingTimeService)Preconditions.checkNotNull((Object)timerService);
            this.interval = autoWatermarkInterval;
        }

        public void start() {
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessingTime(long timestamp) throws Exception {
            Object object = this.checkpointLock;
            synchronized (object) {
                for (PulsarTopicState<T> state : this.allPartitions) {
                    state.onPeriodicEmit();
                }
                this.watermarkOutputMultiplexer.onPeriodicEmit();
            }
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }
    }

    private static class OffsetGauge
    implements Gauge<MessageId> {
        private final PulsarTopicState<?> pts;
        private final OffsetGaugeType gaugeType;

        OffsetGauge(PulsarTopicState<?> pts, OffsetGaugeType gaugeType) {
            this.pts = pts;
            this.gaugeType = gaugeType;
        }

        public MessageId getValue() {
            switch (this.gaugeType) {
                case COMMITTED_OFFSET: {
                    return this.pts.getCommittedOffset();
                }
                case CURRENT_OFFSET: {
                    return this.pts.getOffset();
                }
            }
            throw new RuntimeException("Unknown gauge type: " + (Object)((Object)this.gaugeType));
        }
    }

    private static enum OffsetGaugeType {
        CURRENT_OFFSET,
        COMMITTED_OFFSET;

    }
}

