/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.atomic;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.atomic.AtomicRowDataDeserializationSchema;
import org.apache.flink.formats.atomic.AtomicRowDataSerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.util.DataTypeUtils;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;

public class AtomicRowDataFormatFactory
implements SerializationFormatFactory,
DeserializationFormatFactory {
    public static final String IDENTIFIER = "atomic";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig readableConfig) {
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType dataType) {
                return new AtomicRowDataDeserializationSchema.Builder(AtomicRowDataFormatFactory.this.getClassName(dataType)).useExtendFields(false).build();
            }
        };
    }

    private String getClassName(@Nullable DataType dataType) {
        String classname;
        if (dataType instanceof AtomicDataType) {
            Optional<Class<Class>> classOptional = DataTypeUtils.extractType(dataType);
            classname = classOptional.map(Class::getName).orElse(null);
        } else if (dataType instanceof FieldsDataType) {
            DataType type = (DataType)dataType.getChildren().get(0);
            Optional<Class<Class>> classOptional = DataTypeUtils.extractType(type);
            classname = classOptional.map(Class::getName).orElse(null);
        } else {
            throw new IllegalArgumentException();
        }
        return classname;
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig readableConfig) {
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType dataType) {
                return new AtomicRowDataSerializationSchema.Builder(AtomicRowDataFormatFactory.this.getClassName(dataType)).useExtendFields(false).build();
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }
}

