/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.util;

import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.util.function.ThrowingRunnable;

public class ComponentClosingUtils {
    private ComponentClosingUtils() {
    }

    public static Optional<Throwable> closeWithTimeout(String componentName, ThrowingRunnable<Exception> closingSequence, long closeTimeoutMs) {
        return ComponentClosingUtils.closeWithTimeout(componentName, () -> {
            try {
                closingSequence.run();
            }
            catch (Exception e) {
                throw new ClosingException(componentName, e);
            }
        }, closeTimeoutMs);
    }

    public static Optional<Throwable> closeWithTimeout(String componentName, Runnable closingSequence, long closeTimeoutMs) {
        AtomicReference<Throwable> closingError = new AtomicReference<Throwable>();
        Thread t = new Thread(closingSequence);
        t.setUncaughtExceptionHandler((thread, error) -> closingError.set(error));
        t.start();
        try {
            t.join(closeTimeoutMs);
        }
        catch (InterruptedException e) {
            ComponentClosingUtils.reportError(closingError, e);
        }
        if (t.isAlive()) {
            ComponentClosingUtils.reportError(closingError, new TimeoutException(String.format("Failed to close the %s before timeout of %d milliseconds", componentName, closeTimeoutMs)));
            t.interrupt();
        }
        return Optional.ofNullable(closingError.get());
    }

    private static void reportError(AtomicReference<Throwable> errorRef, Throwable toReport) {
        if (!errorRef.compareAndSet(null, toReport)) {
            errorRef.get().addSuppressed(toReport);
        }
    }

    private static class ClosingException
    extends RuntimeException {
        private static final long serialVersionUID = 2527474477287706295L;

        private ClosingException(String componentName, Exception e) {
            super(String.format("Caught exception when closing %s", componentName), e);
        }
    }
}

