/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.subscription;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.BrokerPartition;
import org.apache.flink.connector.pulsar.source.SplitDivisionStrategy;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.subscription.AbstractPulsarSubscriber;
import org.apache.flink.connector.pulsar.source.util.AsyncUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Range;

public class TopicPatternSubscriber
extends AbstractPulsarSubscriber {
    private static final long serialVersionUID = -7471048577725467797L;
    private final String namespace;
    private final SplitDivisionStrategy splitDivisionStrategy;
    private final Pattern topicPattern;

    public TopicPatternSubscriber(String namespace, SplitDivisionStrategy splitDivisionStrategy, Set<String> topicPatterns) {
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace);
        this.splitDivisionStrategy = (SplitDivisionStrategy)Preconditions.checkNotNull((Object)splitDivisionStrategy);
        Preconditions.checkArgument((topicPatterns.size() > 0 ? 1 : 0) != 0, (Object)"At least one pattern needs to be specified");
        this.topicPattern = Pattern.compile(topicPatterns.stream().map(topic -> "persistent://" + namespace + "/" + topic).collect(Collectors.joining("|")));
    }

    @Override
    public Collection<AbstractPartition> getCurrentPartitions(PulsarAdmin pulsarAdmin) throws PulsarAdminException, InterruptedException, IOException {
        ArrayList<AbstractPartition> partitions = new ArrayList<AbstractPartition>();
        Topics topics = pulsarAdmin.topics();
        List partitionedTopicList = topics.getPartitionedTopicList(this.namespace);
        try {
            AsyncUtils.parallelAsync(partitionedTopicList, arg_0 -> ((Topics)pulsarAdmin.topics()).getPartitionedTopicMetadataAsync(arg_0), (topic, topicMetadata) -> {
                if (this.topicPattern.matcher((CharSequence)topic).matches()) {
                    int numPartitions = topicMetadata.partitions;
                    Collection<Range> ranges = this.splitDivisionStrategy.getRanges((String)topic, pulsarAdmin, (SplitEnumeratorContext<PulsarPartitionSplit>)this.context);
                    for (Range range : ranges) {
                        if (numPartitions == 0) {
                            partitions.add(new BrokerPartition(new TopicRange((String)topic, range)));
                            continue;
                        }
                        for (int partitionIndex = 0; partitionIndex < topicMetadata.partitions; ++partitionIndex) {
                            String fullName = topic + "-partition-" + partitionIndex;
                            partitions.add(new BrokerPartition(new TopicRange(fullName, range)));
                        }
                    }
                }
            }, PulsarAdminException.class);
        }
        catch (TimeoutException e) {
            throw new IOException("Cannot retrieve partition information: " + e.getMessage());
        }
        return partitions;
    }
}

