/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.SplitDivisionStrategy;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.subscription.TopicListSubscriber;
import org.apache.flink.connector.pulsar.source.subscription.TopicPatternSubscriber;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;

@PublicEvolving
public abstract class PulsarSubscriber
implements Serializable {
    protected SplitEnumeratorContext<PulsarPartitionSplit> context;

    public void setContext(SplitEnumeratorContext<PulsarPartitionSplit> context) {
        this.context = context;
    }

    public abstract PartitionChange getPartitionChanges(PulsarAdmin var1, Set<AbstractPartition> var2) throws PulsarAdminException, InterruptedException, IOException;

    public static PulsarSubscriber getTopicListSubscriber(SplitDivisionStrategy splitDivisionStrategy, String ... topics) {
        return new TopicListSubscriber(splitDivisionStrategy, topics);
    }

    public static PulsarSubscriber getTopicPatternSubscriber(String namespace, SplitDivisionStrategy splitDivisionStrategy, Set<String> topicPatterns) {
        return new TopicPatternSubscriber(namespace, splitDivisionStrategy, topicPatterns);
    }

    public class PartitionChange {
        private final Set<AbstractPartition> newPartitions;
        private final Set<AbstractPartition> removedPartitions;

        public PartitionChange(Set<AbstractPartition> newPartitions, Set<AbstractPartition> removedPartitions) {
            this.newPartitions = newPartitions;
            this.removedPartitions = removedPartitions;
        }

        public Set<AbstractPartition> getNewPartitions() {
            return this.newPartitions;
        }

        public Set<AbstractPartition> getRemovedPartitions() {
            return this.removedPartitions;
        }
    }
}

