/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import javax.annotation.Nullable;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicState;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;

public class PulsarTopicStateWithPunctuatedWatermarks<T>
extends PulsarTopicState {
    private final AssignerWithPunctuatedWatermarks<T> timestampsAndWatermarks;
    private volatile long partitionWatermark;

    public PulsarTopicStateWithPunctuatedWatermarks(String topic, AssignerWithPunctuatedWatermarks<T> timestampsAndWatermarks) {
        super(topic);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public PulsarTopicStateWithPunctuatedWatermarks(TopicRange topicRange, AssignerWithPunctuatedWatermarks<T> timestampsAndWatermarks) {
        super(topicRange);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public long getTimestampForRecord(T record, long timestamp) {
        return this.timestampsAndWatermarks.extractTimestamp(record, timestamp);
    }

    @Nullable
    public Watermark checkAndGetNewWatermark(T record, long timestamp) {
        Watermark mark = this.timestampsAndWatermarks.checkAndGetNextWatermark(record, timestamp);
        if (mark != null && mark.getTimestamp() > this.partitionWatermark) {
            this.partitionWatermark = mark.getTimestamp();
            return mark;
        }
        return null;
    }

    public long getCurrentPartitionWatermark() {
        return this.partitionWatermark;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic-range", (Object)this.getTopicRange()).add("offset", (Object)(this.isOffsetDefined() ? this.getOffset().toString() : "not set")).add("watermark", this.partitionWatermark).toString();
    }
}

