/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarMetadataReader;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;

public class PulsarCatalogSupport {
    private PulsarMetadataReader pulsarMetadataReader;
    private SchemaTranslator schemaTranslator;

    public PulsarCatalogSupport(String adminUrl, ClientConfigurationData clientConfigurationData, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks, SchemaTranslator schemaTranslator) throws PulsarClientException {
        this.pulsarMetadataReader = new PulsarMetadataReader(adminUrl, clientConfigurationData, subscriptionName, caseInsensitiveParams, indexOfThisSubtask, numParallelSubtasks);
        this.schemaTranslator = schemaTranslator;
    }

    public List<String> listNamespaces() throws PulsarAdminException {
        return this.pulsarMetadataReader.listNamespaces();
    }

    public boolean namespaceExists(String databaseName) throws PulsarAdminException {
        return this.pulsarMetadataReader.namespaceExists(databaseName);
    }

    public void createNamespace(String name) throws PulsarAdminException {
        this.pulsarMetadataReader.createNamespace(name);
    }

    public List<String> getTopics(String databaseName) throws PulsarAdminException {
        return this.pulsarMetadataReader.getTopics(databaseName);
    }

    public TableSchema getTableSchema(ObjectPath tablePath) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        SchemaInfo pulsarSchema = this.pulsarMetadataReader.getPulsarSchema(topicName);
        return this.pulsarSchemaToTableSchema(pulsarSchema);
    }

    public boolean topicExists(ObjectPath tablePath) throws PulsarAdminException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        return this.pulsarMetadataReader.topicExists(topicName);
    }

    public void createTopic(ObjectPath tablePath, int defaultNumPartitions, CatalogBaseTable table) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        this.pulsarMetadataReader.createTopic(topicName, defaultNumPartitions);
    }

    public void putSchema(ObjectPath tablePath, CatalogBaseTable table) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        TableSchema schema = table.getSchema();
        this.pulsarMetadataReader.putSchema(topicName, this.tableSchemaToPulsarSchema(schema));
    }

    private SchemaInfo tableSchemaToPulsarSchema(TableSchema schema) throws IncompatibleSchemaException {
        return this.schemaTranslator.tableSchemaToPulsarSchema(schema);
    }

    private TableSchema pulsarSchemaToTableSchema(SchemaInfo pulsarSchema) throws IncompatibleSchemaException {
        return this.schemaTranslator.pulsarSchemaToTableSchema(pulsarSchema);
    }

    public static String objectPath2TopicName(ObjectPath objectPath) {
        NamespaceName ns = NamespaceName.get((String)objectPath.getDatabaseName());
        String topic = objectPath.getObjectName();
        TopicName fullName = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)ns, (String)topic);
        return fullName.toString();
    }

    public void close() {
        if (this.pulsarMetadataReader != null) {
            this.pulsarMetadataReader.close();
        }
    }

    public void deleteTopic(ObjectPath tablePath) throws PulsarAdminException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        this.pulsarMetadataReader.deleteTopic(topicName);
    }

    public void deleteNamespace(String name) throws PulsarAdminException {
        this.pulsarMetadataReader.deleteNamespace(name);
    }
}

