/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.com.google.common.cache.RemovalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPulsarClient {
    private static final Logger log = LoggerFactory.getLogger(CachedPulsarClient.class);
    private static int cacheSize = 100;
    private static CacheLoader<ClientConfigurationData, PulsarClientImpl> cacheLoader = new CacheLoader<ClientConfigurationData, PulsarClientImpl>(){

        public PulsarClientImpl load(ClientConfigurationData key) throws Exception {
            return CachedPulsarClient.createPulsarClient(key);
        }
    };
    private static RemovalListener<ClientConfigurationData, PulsarClientImpl> removalListener = notification -> {
        ClientConfigurationData config = (ClientConfigurationData)notification.getKey();
        PulsarClientImpl client = (PulsarClientImpl)notification.getValue();
        log.debug("Evicting pulsar client {} with config {}, due to {}", new Object[]{client.toString(), config.toString(), notification.getCause().toString()});
        CachedPulsarClient.close(config, client);
    };
    private static volatile LoadingCache<ClientConfigurationData, PulsarClientImpl> guavaCache;

    public static void setCacheSize(int newSize) {
        cacheSize = newSize;
    }

    public static int getCacheSize() {
        return cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoadingCache<ClientConfigurationData, PulsarClientImpl> getGuavaCache() {
        if (guavaCache != null) {
            return guavaCache;
        }
        Class<CachedPulsarClient> clazz = CachedPulsarClient.class;
        synchronized (CachedPulsarClient.class) {
            if (guavaCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return guavaCache;
            }
            guavaCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(removalListener).build(cacheLoader);
            // ** MonitorExit[var0] (shouldn't be in output)
            return guavaCache;
        }
    }

    private static PulsarClientImpl createPulsarClient(ClientConfigurationData clientConfig) throws PulsarClientException {
        PulsarClientImpl client;
        try {
            client = new PulsarClientImpl(clientConfig);
            log.debug("Created a new instance of PulsarClientImpl for clientConf = {}", (Object)clientConfig.toString());
        }
        catch (PulsarClientException e) {
            log.error("Failed to create PulsarClientImpl for clientConf = {}", (Object)clientConfig.toString());
            throw e;
        }
        return client;
    }

    public static PulsarClientImpl getOrCreate(ClientConfigurationData config) throws ExecutionException {
        return (PulsarClientImpl)CachedPulsarClient.getGuavaCache().get((Object)config);
    }

    private static void close(ClientConfigurationData clientConfig, PulsarClientImpl client) {
        try {
            log.info("Closing the Pulsar client with conifg {}", (Object)clientConfig.toString());
            client.close();
        }
        catch (PulsarClientException e) {
            log.warn(String.format("Error while closing the Pulsar client %s", clientConfig.toString()), (Throwable)e);
        }
    }

    static void close(ClientConfigurationData clientConfig) {
        CachedPulsarClient.getGuavaCache().invalidate((Object)clientConfig);
    }

    static void clear() {
        log.info("Cleaning up guava cache.");
        CachedPulsarClient.getGuavaCache().invalidateAll();
    }

    static ConcurrentMap<ClientConfigurationData, PulsarClientImpl> getAsMap() {
        return CachedPulsarClient.getGuavaCache().asMap();
    }
}

