/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.connectors.pulsar.FlinkPulsarSink;
import org.apache.flink.streaming.connectors.pulsar.PulsarRowSerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.SupportsWritingMetadata;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarClientUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;

public class PulsarTableSink
implements AppendStreamTableSink<Row>,
SupportsWritingMetadata {
    protected List<String> metadataKeys;
    protected DataType physicalDataType;
    protected final boolean useExtendField;
    private final String adminUrl;
    private final TableSchema schema;
    private final String defaultTopicName;
    private final ClientConfigurationData clientConf;
    private final Properties properties;
    private SerializationSchema serializationSchema;

    public PulsarTableSink(String adminUrl, TableSchema schema, String defaultTopicName, ClientConfigurationData clientConf, Properties properties, SerializationSchema serializationSchema) {
        this.adminUrl = (String)Preconditions.checkNotNull((Object)adminUrl);
        this.schema = (TableSchema)Preconditions.checkNotNull((Object)schema);
        this.defaultTopicName = defaultTopicName;
        this.clientConf = (ClientConfigurationData)Preconditions.checkNotNull((Object)clientConf);
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
        this.serializationSchema = serializationSchema;
        this.physicalDataType = schema.toRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.useExtendField = Boolean.parseBoolean(properties.getProperty("use-extend-field", "false"));
    }

    public PulsarTableSink(String serviceUrl, String adminUrl, TableSchema schema, String defaultTopicName, Properties properties, SerializationSchema serializationSchema) {
        this(adminUrl, schema, defaultTopicName, PulsarClientUtils.newClientConf((String)Preconditions.checkNotNull((Object)serviceUrl), properties), properties, serializationSchema);
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        this.consumeDataStream(dataStream);
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        if (this.useExtendField) {
            this.metadataKeys = Arrays.stream(WritableMetadata.values()).map(x -> x.key).collect(Collectors.toList());
            this.applyWritableMetadata(this.metadataKeys, null);
        }
        List physicalChildren = this.physicalDataType.getLogicalType().getChildren();
        String formatName = this.properties.getProperty("format.type");
        int[] physicalPos = IntStream.range(0, physicalChildren.size()).toArray();
        RecordSchemaType recordSchemaType = Enum.valueOf(RecordSchemaType.class, formatName.toUpperCase());
        int[] metadataPositions = Stream.of(WritableMetadata.values()).mapToInt(m -> {
            int pos = this.metadataKeys.indexOf(m.key);
            if (pos < 0) {
                return -1;
            }
            return physicalChildren.size() + pos;
        }).toArray();
        PulsarRowSerializationSchema pulsarRowSerializationSchema = new PulsarRowSerializationSchema(this.defaultTopicName, (SerializationSchema<Row>)this.serializationSchema, this.metadataKeys.size() > 0, metadataPositions, physicalPos, recordSchemaType, this.physicalDataType);
        FlinkPulsarSink sink = new FlinkPulsarSink(this.adminUrl, Optional.of(this.defaultTopicName), this.clientConf, this.properties, (PulsarSerializationSchema)pulsarRowSerializationSchema);
        return dataStream.addSink(sink).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getFieldNames()));
    }

    public TypeInformation<Row> getOutputType() {
        return this.schema.toRowType();
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public String[] getFieldNames() {
        return this.schema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.getFieldTypes();
    }

    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        return this;
    }

    @Override
    public Map<String, DataType> listWritableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(WritableMetadata.values()).forEachOrdered(m -> metadataMap.put(m.key, m.dataType));
        return metadataMap;
    }

    @Override
    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        this.metadataKeys = metadataKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarTableSink)) {
            return false;
        }
        PulsarTableSink other = (PulsarTableSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$metadataKeys = this.metadataKeys;
        List<String> other$metadataKeys = other.metadataKeys;
        if (this$metadataKeys == null ? other$metadataKeys != null : !((Object)this$metadataKeys).equals(other$metadataKeys)) {
            return false;
        }
        DataType this$physicalDataType = this.physicalDataType;
        DataType other$physicalDataType = other.physicalDataType;
        if (this$physicalDataType == null ? other$physicalDataType != null : !this$physicalDataType.equals(other$physicalDataType)) {
            return false;
        }
        if (this.useExtendField != other.useExtendField) {
            return false;
        }
        String this$adminUrl = this.adminUrl;
        String other$adminUrl = other.adminUrl;
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        TableSchema this$schema = this.schema;
        TableSchema other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$defaultTopicName = this.defaultTopicName;
        String other$defaultTopicName = other.defaultTopicName;
        if (this$defaultTopicName == null ? other$defaultTopicName != null : !this$defaultTopicName.equals(other$defaultTopicName)) {
            return false;
        }
        ClientConfigurationData this$clientConf = this.clientConf;
        ClientConfigurationData other$clientConf = other.clientConf;
        if (this$clientConf == null ? other$clientConf != null : !this$clientConf.equals(other$clientConf)) {
            return false;
        }
        Properties this$properties = this.properties;
        Properties other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        SerializationSchema this$serializationSchema = this.serializationSchema;
        SerializationSchema other$serializationSchema = other.serializationSchema;
        return !(this$serializationSchema == null ? other$serializationSchema != null : !this$serializationSchema.equals(other$serializationSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarTableSink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $metadataKeys = this.metadataKeys;
        result = result * 59 + ($metadataKeys == null ? 43 : ((Object)$metadataKeys).hashCode());
        DataType $physicalDataType = this.physicalDataType;
        result = result * 59 + ($physicalDataType == null ? 43 : $physicalDataType.hashCode());
        result = result * 59 + (this.useExtendField ? 79 : 97);
        String $adminUrl = this.adminUrl;
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        TableSchema $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $defaultTopicName = this.defaultTopicName;
        result = result * 59 + ($defaultTopicName == null ? 43 : $defaultTopicName.hashCode());
        ClientConfigurationData $clientConf = this.clientConf;
        result = result * 59 + ($clientConf == null ? 43 : $clientConf.hashCode());
        Properties $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        SerializationSchema $serializationSchema = this.serializationSchema;
        result = result * 59 + ($serializationSchema == null ? 43 : $serializationSchema.hashCode());
        return result;
    }

    static enum WritableMetadata {
        TIMESTAMP("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), (row, pos) -> {
            if (row.getField(pos) == null) {
                return null;
            }
            return ((TimestampData)row.getField(pos)).getMillisecond();
        });

        public final String key;
        public final DataType dataType;
        public final PulsarRowSerializationSchema.WritableRowMetadataConverter converter;

        private WritableMetadata(String key, DataType dataType, PulsarRowSerializationSchema.WritableRowMetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

