/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializationSchema;
import org.apache.flink.types.Row;
import org.apache.pulsar.client.api.Message;

public class PulsarRowDeserializationSchema
implements PulsarDeserializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private final DeserializationSchema<Row> valueDeserialization;
    private final boolean hasMetadata;
    private final ReadableRowMetadataConverter[] metadataConverters;
    private final TypeInformation<Row> producedTypeInfo;

    PulsarRowDeserializationSchema(DeserializationSchema<Row> valueDeserialization, boolean hasMetadata, ReadableRowMetadataConverter[] metadataConverters, TypeInformation<Row> producedTypeInfo) {
        this.hasMetadata = hasMetadata;
        this.valueDeserialization = valueDeserialization;
        this.producedTypeInfo = producedTypeInfo;
        this.metadataConverters = metadataConverters;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.valueDeserialization.open(context);
    }

    @Override
    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    @Override
    public Row deserialize(Message record) throws IOException {
        int i;
        if (!this.hasMetadata) {
            return (Row)this.valueDeserialization.deserialize(record.getData());
        }
        Row physicalRow = (Row)this.valueDeserialization.deserialize(record.getData());
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        Row producedRow = new Row(physicalRow.getKind(), physicalArity + metadataArity);
        for (i = 0; i < physicalArity; ++i) {
            producedRow.setField(i, physicalRow.getField(i));
        }
        for (i = 0; i < metadataArity; ++i) {
            producedRow.setField(i + physicalArity, this.metadataConverters[i].read(record));
        }
        return producedRow;
    }

    public TypeInformation<Row> getProducedType() {
        if (this.hasMetadata) {
            return this.producedTypeInfo;
        }
        return this.valueDeserialization.getProducedType();
    }

    static interface ReadableRowMetadataConverter
    extends Serializable {
        public Object read(Message var1);
    }
}

