/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.pulsar.table.PulsarDynamicTableSink;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarContextAware;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarSerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public class DynamicPulsarSerializationSchema
implements PulsarSerializationSchema<RowData>,
PulsarContextAware<RowData> {
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final SerializationSchema<RowData> valueSerialization;
    private final boolean hasMetadata;
    private final int[] metadataPositions;
    private final RowData.FieldGetter[] physicalFieldGetters;
    private final RecordSchemaType recordSchemaType;
    private final DataType dataType;
    private int[] partitions;
    private int parallelInstanceId;
    private int numParallelInstances;

    DynamicPulsarSerializationSchema(String topic, SerializationSchema<RowData> valueSerialization, boolean hasMetadata, int[] metadataPositions, RowData.FieldGetter[] physicalFieldGetters, RecordSchemaType recordSchemaType, DataType dataType) {
        this.topic = topic;
        this.valueSerialization = valueSerialization;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.physicalFieldGetters = physicalFieldGetters;
        this.recordSchemaType = recordSchemaType;
        this.dataType = dataType;
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.valueSerialization.open(context);
    }

    @Override
    public byte[] serialize(RowData element) {
        throw new IllegalStateException("In Row mode we use serialize method with 2 args");
    }

    @Override
    public void serialize(RowData consumedRow, TypedMessageBuilder<byte[]> messageBuilder) {
        RowData physicalRow;
        if (!this.hasMetadata) {
            physicalRow = consumedRow;
        } else {
            int physicalArity = this.physicalFieldGetters.length;
            GenericRowData genericRowData = new GenericRowData(consumedRow.getRowKind(), physicalArity);
            for (int i = 0; i < physicalArity; ++i) {
                genericRowData.setField(i, this.physicalFieldGetters[i].getFieldOrNull(consumedRow));
            }
            physicalRow = genericRowData;
        }
        byte[] valueSerialized = this.valueSerialization.serialize((Object)physicalRow);
        messageBuilder.value((Object)valueSerialized);
    }

    @Override
    public Schema<?> getPulsarSchema() {
        return SchemaUtils.buildRowSchema(this.dataType, this.recordSchemaType);
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    @Override
    public void setPartitions(int[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public String getTargetTopic(RowData element) {
        return this.topic;
    }

    @Override
    public byte[] getKey(RowData element) {
        return null;
    }

    private <T> T readMetadata(RowData consumedRow, PulsarDynamicTableSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }

    static interface WritableRowDataMetadataConverter {
        public Object read(RowData var1, int var2);
    }
}

