/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.SplitDivisionStrategy;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceSinkUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Range;

public class UniformSplitDivisionStrategy
implements SplitDivisionStrategy {
    @Override
    public Collection<Range> getRanges(String topic, PulsarAdmin pulsarAdmin, SplitEnumeratorContext<PulsarPartitionSplit> context) throws PulsarAdminException {
        int numReaders = context.currentParallelism();
        ArrayList<Range> rangeList = new ArrayList<Range>();
        for (int subtaskIdx = 0; subtaskIdx < numReaders; ++subtaskIdx) {
            Range range = SourceSinkUtils.distributeRange(numReaders, subtaskIdx);
            rangeList.add(range);
        }
        return rangeList;
    }
}

