/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.common.ConnectorConfig;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.FastThreadLocal;

public final class ConnectorConfigUtils {
    private static final FastThreadLocal<ObjectMapper> mapper = new FastThreadLocal<ObjectMapper>(){

        protected ObjectMapper initialValue() throws Exception {
            return ConnectorConfigUtils.create();
        }
    };

    private ConnectorConfigUtils() {
    }

    public static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static ObjectMapper getThreadLocal() {
        return (ObjectMapper)mapper.get();
    }

    public static ConnectorConfig loadData(Map<String, String> config) {
        return ConnectorConfigUtils.loadData(config, new ConnectorConfig());
    }

    public static ConnectorConfig loadData(Map<String, String> config, ConnectorConfig existingData) {
        ObjectMapper mapper = ConnectorConfigUtils.getThreadLocal();
        try {
            String existingConfigJson = mapper.writeValueAsString((Object)existingData);
            Map existingConfig = (Map)mapper.readValue(existingConfigJson, Map.class);
            HashMap newConfig = Maps.newHashMap();
            newConfig.putAll(existingConfig);
            newConfig.putAll(config);
            String configJson = mapper.writeValueAsString((Object)newConfig);
            return (ConnectorConfig)mapper.readValue(configJson, ConnectorConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config into existing configuration data", e);
        }
    }
}

