/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsProvider;

public class ConnectorConfig
implements Serializable {
    private String serviceUrl;
    private String adminUrl;
    private String zookeeperUri;
    private String authPluginClassName;
    private String authParams;
    private String tlsTrustCertsFilePath;
    private Boolean tlsAllowInsecureConnection;
    private Boolean tlsHostnameVerificationEnable;
    private String topic;
    private String topics;
    private String topicsPattern;
    private int entryReadBatchSize = 100;
    private int targetNumSplits = 2;
    private int maxSplitMessageQueueSize = 10000;
    private int maxSplitEntryQueueSize = 1000;
    private int maxMessageSize = 0x500000;
    private String statsProvider = NullStatsProvider.class.getName();
    private Map<String, String> statsProviderConfigs = new HashMap<String, String>();
    private boolean namespaceDelimiterRewriteEnable = false;
    private String rewriteNamespaceDelimiter = "/";
    private String managedLedgerOffloadDriver = null;
    private int managedLedgerOffloadMaxThreads = 2;
    private String offloadersDirectory = "./offloaders";
    private Map<String, String> offloaderProperties = new HashMap<String, String>();
    private int bookkeeperThrottleValue = 0;
    private int bookkeeperNumIOThreads = 2 * Runtime.getRuntime().availableProcessors();
    private int bookkeeperNumWorkerThreads = Runtime.getRuntime().availableProcessors();
    private long managedLedgerCacheSizeMB = 0L;
    private int managedLedgerNumWorkerThreads = Runtime.getRuntime().availableProcessors();
    private int managedLedgerNumSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private long partitionDiscoveryIntervalMillis = -1L;
    private boolean failOnDataLoss = true;
    private int clientCacheSize = 5;
    private boolean flushOnCheckpoint = true;
    private boolean failOnWrite = false;
    private int pollTimeoutMs = 120000;
    private int commitMaxRetries = 3;

    public ConnectorConfig(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getZookeeperUri() {
        return this.zookeeperUri;
    }

    public String getAuthPluginClassName() {
        return this.authPluginClassName;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public Boolean getTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public Boolean getTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTopics() {
        return this.topics;
    }

    public String getTopicsPattern() {
        return this.topicsPattern;
    }

    public int getEntryReadBatchSize() {
        return this.entryReadBatchSize;
    }

    public int getTargetNumSplits() {
        return this.targetNumSplits;
    }

    public int getMaxSplitMessageQueueSize() {
        return this.maxSplitMessageQueueSize;
    }

    public int getMaxSplitEntryQueueSize() {
        return this.maxSplitEntryQueueSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public String getStatsProvider() {
        return this.statsProvider;
    }

    public Map<String, String> getStatsProviderConfigs() {
        return this.statsProviderConfigs;
    }

    public boolean isNamespaceDelimiterRewriteEnable() {
        return this.namespaceDelimiterRewriteEnable;
    }

    public String getRewriteNamespaceDelimiter() {
        return this.rewriteNamespaceDelimiter;
    }

    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    public int getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    public Map<String, String> getOffloaderProperties() {
        return this.offloaderProperties;
    }

    public int getBookkeeperThrottleValue() {
        return this.bookkeeperThrottleValue;
    }

    public int getBookkeeperNumIOThreads() {
        return this.bookkeeperNumIOThreads;
    }

    public int getBookkeeperNumWorkerThreads() {
        return this.bookkeeperNumWorkerThreads;
    }

    public long getManagedLedgerCacheSizeMB() {
        return this.managedLedgerCacheSizeMB;
    }

    public int getManagedLedgerNumWorkerThreads() {
        return this.managedLedgerNumWorkerThreads;
    }

    public int getManagedLedgerNumSchedulerThreads() {
        return this.managedLedgerNumSchedulerThreads;
    }

    public long getPartitionDiscoveryIntervalMillis() {
        return this.partitionDiscoveryIntervalMillis;
    }

    public boolean isFailOnDataLoss() {
        return this.failOnDataLoss;
    }

    public int getClientCacheSize() {
        return this.clientCacheSize;
    }

    public boolean isFlushOnCheckpoint() {
        return this.flushOnCheckpoint;
    }

    public boolean isFailOnWrite() {
        return this.failOnWrite;
    }

    public int getPollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public int getCommitMaxRetries() {
        return this.commitMaxRetries;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setZookeeperUri(String zookeeperUri) {
        this.zookeeperUri = zookeeperUri;
    }

    public void setAuthPluginClassName(String authPluginClassName) {
        this.authPluginClassName = authPluginClassName;
    }

    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(Boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnable(Boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setEntryReadBatchSize(int entryReadBatchSize) {
        this.entryReadBatchSize = entryReadBatchSize;
    }

    public void setTargetNumSplits(int targetNumSplits) {
        this.targetNumSplits = targetNumSplits;
    }

    public void setMaxSplitMessageQueueSize(int maxSplitMessageQueueSize) {
        this.maxSplitMessageQueueSize = maxSplitMessageQueueSize;
    }

    public void setMaxSplitEntryQueueSize(int maxSplitEntryQueueSize) {
        this.maxSplitEntryQueueSize = maxSplitEntryQueueSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setStatsProvider(String statsProvider) {
        this.statsProvider = statsProvider;
    }

    public void setStatsProviderConfigs(Map<String, String> statsProviderConfigs) {
        this.statsProviderConfigs = statsProviderConfigs;
    }

    public void setNamespaceDelimiterRewriteEnable(boolean namespaceDelimiterRewriteEnable) {
        this.namespaceDelimiterRewriteEnable = namespaceDelimiterRewriteEnable;
    }

    public void setRewriteNamespaceDelimiter(String rewriteNamespaceDelimiter) {
        this.rewriteNamespaceDelimiter = rewriteNamespaceDelimiter;
    }

    public void setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
    }

    public void setManagedLedgerOffloadMaxThreads(int managedLedgerOffloadMaxThreads) {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
    }

    public void setOffloadersDirectory(String offloadersDirectory) {
        this.offloadersDirectory = offloadersDirectory;
    }

    public void setOffloaderProperties(Map<String, String> offloaderProperties) {
        this.offloaderProperties = offloaderProperties;
    }

    public void setBookkeeperThrottleValue(int bookkeeperThrottleValue) {
        this.bookkeeperThrottleValue = bookkeeperThrottleValue;
    }

    public void setBookkeeperNumIOThreads(int bookkeeperNumIOThreads) {
        this.bookkeeperNumIOThreads = bookkeeperNumIOThreads;
    }

    public void setBookkeeperNumWorkerThreads(int bookkeeperNumWorkerThreads) {
        this.bookkeeperNumWorkerThreads = bookkeeperNumWorkerThreads;
    }

    public void setManagedLedgerCacheSizeMB(long managedLedgerCacheSizeMB) {
        this.managedLedgerCacheSizeMB = managedLedgerCacheSizeMB;
    }

    public void setManagedLedgerNumWorkerThreads(int managedLedgerNumWorkerThreads) {
        this.managedLedgerNumWorkerThreads = managedLedgerNumWorkerThreads;
    }

    public void setManagedLedgerNumSchedulerThreads(int managedLedgerNumSchedulerThreads) {
        this.managedLedgerNumSchedulerThreads = managedLedgerNumSchedulerThreads;
    }

    public void setPartitionDiscoveryIntervalMillis(long partitionDiscoveryIntervalMillis) {
        this.partitionDiscoveryIntervalMillis = partitionDiscoveryIntervalMillis;
    }

    public void setFailOnDataLoss(boolean failOnDataLoss) {
        this.failOnDataLoss = failOnDataLoss;
    }

    public void setClientCacheSize(int clientCacheSize) {
        this.clientCacheSize = clientCacheSize;
    }

    public void setFlushOnCheckpoint(boolean flushOnCheckpoint) {
        this.flushOnCheckpoint = flushOnCheckpoint;
    }

    public void setFailOnWrite(boolean failOnWrite) {
        this.failOnWrite = failOnWrite;
    }

    public void setPollTimeoutMs(int pollTimeoutMs) {
        this.pollTimeoutMs = pollTimeoutMs;
    }

    public void setCommitMaxRetries(int commitMaxRetries) {
        this.commitMaxRetries = commitMaxRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorConfig)) {
            return false;
        }
        ConnectorConfig other = (ConnectorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$zookeeperUri = this.getZookeeperUri();
        String other$zookeeperUri = other.getZookeeperUri();
        if (this$zookeeperUri == null ? other$zookeeperUri != null : !this$zookeeperUri.equals(other$zookeeperUri)) {
            return false;
        }
        String this$authPluginClassName = this.getAuthPluginClassName();
        String other$authPluginClassName = other.getAuthPluginClassName();
        if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
            return false;
        }
        String this$authParams = this.getAuthParams();
        String other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        Boolean this$tlsAllowInsecureConnection = this.getTlsAllowInsecureConnection();
        Boolean other$tlsAllowInsecureConnection = other.getTlsAllowInsecureConnection();
        if (this$tlsAllowInsecureConnection == null ? other$tlsAllowInsecureConnection != null : !((Object)this$tlsAllowInsecureConnection).equals(other$tlsAllowInsecureConnection)) {
            return false;
        }
        Boolean this$tlsHostnameVerificationEnable = this.getTlsHostnameVerificationEnable();
        Boolean other$tlsHostnameVerificationEnable = other.getTlsHostnameVerificationEnable();
        if (this$tlsHostnameVerificationEnable == null ? other$tlsHostnameVerificationEnable != null : !((Object)this$tlsHostnameVerificationEnable).equals(other$tlsHostnameVerificationEnable)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$topics = this.getTopics();
        String other$topics = other.getTopics();
        if (this$topics == null ? other$topics != null : !this$topics.equals(other$topics)) {
            return false;
        }
        String this$topicsPattern = this.getTopicsPattern();
        String other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        if (this.getEntryReadBatchSize() != other.getEntryReadBatchSize()) {
            return false;
        }
        if (this.getTargetNumSplits() != other.getTargetNumSplits()) {
            return false;
        }
        if (this.getMaxSplitMessageQueueSize() != other.getMaxSplitMessageQueueSize()) {
            return false;
        }
        if (this.getMaxSplitEntryQueueSize() != other.getMaxSplitEntryQueueSize()) {
            return false;
        }
        if (this.getMaxMessageSize() != other.getMaxMessageSize()) {
            return false;
        }
        String this$statsProvider = this.getStatsProvider();
        String other$statsProvider = other.getStatsProvider();
        if (this$statsProvider == null ? other$statsProvider != null : !this$statsProvider.equals(other$statsProvider)) {
            return false;
        }
        Map<String, String> this$statsProviderConfigs = this.getStatsProviderConfigs();
        Map<String, String> other$statsProviderConfigs = other.getStatsProviderConfigs();
        if (this$statsProviderConfigs == null ? other$statsProviderConfigs != null : !((Object)this$statsProviderConfigs).equals(other$statsProviderConfigs)) {
            return false;
        }
        if (this.isNamespaceDelimiterRewriteEnable() != other.isNamespaceDelimiterRewriteEnable()) {
            return false;
        }
        String this$rewriteNamespaceDelimiter = this.getRewriteNamespaceDelimiter();
        String other$rewriteNamespaceDelimiter = other.getRewriteNamespaceDelimiter();
        if (this$rewriteNamespaceDelimiter == null ? other$rewriteNamespaceDelimiter != null : !this$rewriteNamespaceDelimiter.equals(other$rewriteNamespaceDelimiter)) {
            return false;
        }
        String this$managedLedgerOffloadDriver = this.getManagedLedgerOffloadDriver();
        String other$managedLedgerOffloadDriver = other.getManagedLedgerOffloadDriver();
        if (this$managedLedgerOffloadDriver == null ? other$managedLedgerOffloadDriver != null : !this$managedLedgerOffloadDriver.equals(other$managedLedgerOffloadDriver)) {
            return false;
        }
        if (this.getManagedLedgerOffloadMaxThreads() != other.getManagedLedgerOffloadMaxThreads()) {
            return false;
        }
        String this$offloadersDirectory = this.getOffloadersDirectory();
        String other$offloadersDirectory = other.getOffloadersDirectory();
        if (this$offloadersDirectory == null ? other$offloadersDirectory != null : !this$offloadersDirectory.equals(other$offloadersDirectory)) {
            return false;
        }
        Map<String, String> this$offloaderProperties = this.getOffloaderProperties();
        Map<String, String> other$offloaderProperties = other.getOffloaderProperties();
        if (this$offloaderProperties == null ? other$offloaderProperties != null : !((Object)this$offloaderProperties).equals(other$offloaderProperties)) {
            return false;
        }
        if (this.getBookkeeperThrottleValue() != other.getBookkeeperThrottleValue()) {
            return false;
        }
        if (this.getBookkeeperNumIOThreads() != other.getBookkeeperNumIOThreads()) {
            return false;
        }
        if (this.getBookkeeperNumWorkerThreads() != other.getBookkeeperNumWorkerThreads()) {
            return false;
        }
        if (this.getManagedLedgerCacheSizeMB() != other.getManagedLedgerCacheSizeMB()) {
            return false;
        }
        if (this.getManagedLedgerNumWorkerThreads() != other.getManagedLedgerNumWorkerThreads()) {
            return false;
        }
        if (this.getManagedLedgerNumSchedulerThreads() != other.getManagedLedgerNumSchedulerThreads()) {
            return false;
        }
        if (this.getPartitionDiscoveryIntervalMillis() != other.getPartitionDiscoveryIntervalMillis()) {
            return false;
        }
        if (this.isFailOnDataLoss() != other.isFailOnDataLoss()) {
            return false;
        }
        if (this.getClientCacheSize() != other.getClientCacheSize()) {
            return false;
        }
        if (this.isFlushOnCheckpoint() != other.isFlushOnCheckpoint()) {
            return false;
        }
        if (this.isFailOnWrite() != other.isFailOnWrite()) {
            return false;
        }
        if (this.getPollTimeoutMs() != other.getPollTimeoutMs()) {
            return false;
        }
        return this.getCommitMaxRetries() == other.getCommitMaxRetries();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $zookeeperUri = this.getZookeeperUri();
        result = result * 59 + ($zookeeperUri == null ? 43 : $zookeeperUri.hashCode());
        String $authPluginClassName = this.getAuthPluginClassName();
        result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
        String $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        Boolean $tlsAllowInsecureConnection = this.getTlsAllowInsecureConnection();
        result = result * 59 + ($tlsAllowInsecureConnection == null ? 43 : ((Object)$tlsAllowInsecureConnection).hashCode());
        Boolean $tlsHostnameVerificationEnable = this.getTlsHostnameVerificationEnable();
        result = result * 59 + ($tlsHostnameVerificationEnable == null ? 43 : ((Object)$tlsHostnameVerificationEnable).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $topics = this.getTopics();
        result = result * 59 + ($topics == null ? 43 : $topics.hashCode());
        String $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        result = result * 59 + this.getEntryReadBatchSize();
        result = result * 59 + this.getTargetNumSplits();
        result = result * 59 + this.getMaxSplitMessageQueueSize();
        result = result * 59 + this.getMaxSplitEntryQueueSize();
        result = result * 59 + this.getMaxMessageSize();
        String $statsProvider = this.getStatsProvider();
        result = result * 59 + ($statsProvider == null ? 43 : $statsProvider.hashCode());
        Map<String, String> $statsProviderConfigs = this.getStatsProviderConfigs();
        result = result * 59 + ($statsProviderConfigs == null ? 43 : ((Object)$statsProviderConfigs).hashCode());
        result = result * 59 + (this.isNamespaceDelimiterRewriteEnable() ? 79 : 97);
        String $rewriteNamespaceDelimiter = this.getRewriteNamespaceDelimiter();
        result = result * 59 + ($rewriteNamespaceDelimiter == null ? 43 : $rewriteNamespaceDelimiter.hashCode());
        String $managedLedgerOffloadDriver = this.getManagedLedgerOffloadDriver();
        result = result * 59 + ($managedLedgerOffloadDriver == null ? 43 : $managedLedgerOffloadDriver.hashCode());
        result = result * 59 + this.getManagedLedgerOffloadMaxThreads();
        String $offloadersDirectory = this.getOffloadersDirectory();
        result = result * 59 + ($offloadersDirectory == null ? 43 : $offloadersDirectory.hashCode());
        Map<String, String> $offloaderProperties = this.getOffloaderProperties();
        result = result * 59 + ($offloaderProperties == null ? 43 : ((Object)$offloaderProperties).hashCode());
        result = result * 59 + this.getBookkeeperThrottleValue();
        result = result * 59 + this.getBookkeeperNumIOThreads();
        result = result * 59 + this.getBookkeeperNumWorkerThreads();
        long $managedLedgerCacheSizeMB = this.getManagedLedgerCacheSizeMB();
        result = result * 59 + (int)($managedLedgerCacheSizeMB >>> 32 ^ $managedLedgerCacheSizeMB);
        result = result * 59 + this.getManagedLedgerNumWorkerThreads();
        result = result * 59 + this.getManagedLedgerNumSchedulerThreads();
        long $partitionDiscoveryIntervalMillis = this.getPartitionDiscoveryIntervalMillis();
        result = result * 59 + (int)($partitionDiscoveryIntervalMillis >>> 32 ^ $partitionDiscoveryIntervalMillis);
        result = result * 59 + (this.isFailOnDataLoss() ? 79 : 97);
        result = result * 59 + this.getClientCacheSize();
        result = result * 59 + (this.isFlushOnCheckpoint() ? 79 : 97);
        result = result * 59 + (this.isFailOnWrite() ? 79 : 97);
        result = result * 59 + this.getPollTimeoutMs();
        result = result * 59 + this.getCommitMaxRetries();
        return result;
    }

    public String toString() {
        return "ConnectorConfig(serviceUrl=" + this.getServiceUrl() + ", adminUrl=" + this.getAdminUrl() + ", zookeeperUri=" + this.getZookeeperUri() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParams=" + this.getAuthParams() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.getTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.getTlsHostnameVerificationEnable() + ", topic=" + this.getTopic() + ", topics=" + this.getTopics() + ", topicsPattern=" + this.getTopicsPattern() + ", entryReadBatchSize=" + this.getEntryReadBatchSize() + ", targetNumSplits=" + this.getTargetNumSplits() + ", maxSplitMessageQueueSize=" + this.getMaxSplitMessageQueueSize() + ", maxSplitEntryQueueSize=" + this.getMaxSplitEntryQueueSize() + ", maxMessageSize=" + this.getMaxMessageSize() + ", statsProvider=" + this.getStatsProvider() + ", statsProviderConfigs=" + this.getStatsProviderConfigs() + ", namespaceDelimiterRewriteEnable=" + this.isNamespaceDelimiterRewriteEnable() + ", rewriteNamespaceDelimiter=" + this.getRewriteNamespaceDelimiter() + ", managedLedgerOffloadDriver=" + this.getManagedLedgerOffloadDriver() + ", managedLedgerOffloadMaxThreads=" + this.getManagedLedgerOffloadMaxThreads() + ", offloadersDirectory=" + this.getOffloadersDirectory() + ", offloaderProperties=" + this.getOffloaderProperties() + ", bookkeeperThrottleValue=" + this.getBookkeeperThrottleValue() + ", bookkeeperNumIOThreads=" + this.getBookkeeperNumIOThreads() + ", bookkeeperNumWorkerThreads=" + this.getBookkeeperNumWorkerThreads() + ", managedLedgerCacheSizeMB=" + this.getManagedLedgerCacheSizeMB() + ", managedLedgerNumWorkerThreads=" + this.getManagedLedgerNumWorkerThreads() + ", managedLedgerNumSchedulerThreads=" + this.getManagedLedgerNumSchedulerThreads() + ", partitionDiscoveryIntervalMillis=" + this.getPartitionDiscoveryIntervalMillis() + ", failOnDataLoss=" + this.isFailOnDataLoss() + ", clientCacheSize=" + this.getClientCacheSize() + ", flushOnCheckpoint=" + this.isFlushOnCheckpoint() + ", failOnWrite=" + this.isFailOnWrite() + ", pollTimeoutMs=" + this.getPollTimeoutMs() + ", commitMaxRetries=" + this.getCommitMaxRetries() + ")";
    }

    public ConnectorConfig(String serviceUrl, String adminUrl, String zookeeperUri, String authPluginClassName, String authParams, String tlsTrustCertsFilePath, Boolean tlsAllowInsecureConnection, Boolean tlsHostnameVerificationEnable, String topic, String topics, String topicsPattern, int entryReadBatchSize, int targetNumSplits, int maxSplitMessageQueueSize, int maxSplitEntryQueueSize, int maxMessageSize, String statsProvider, Map<String, String> statsProviderConfigs, boolean namespaceDelimiterRewriteEnable, String rewriteNamespaceDelimiter, String managedLedgerOffloadDriver, int managedLedgerOffloadMaxThreads, String offloadersDirectory, Map<String, String> offloaderProperties, int bookkeeperThrottleValue, int bookkeeperNumIOThreads, int bookkeeperNumWorkerThreads, long managedLedgerCacheSizeMB, int managedLedgerNumWorkerThreads, int managedLedgerNumSchedulerThreads, long partitionDiscoveryIntervalMillis, boolean failOnDataLoss, int clientCacheSize, boolean flushOnCheckpoint, boolean failOnWrite, int pollTimeoutMs, int commitMaxRetries) {
        this.serviceUrl = serviceUrl;
        this.adminUrl = adminUrl;
        this.zookeeperUri = zookeeperUri;
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParams;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        this.topic = topic;
        this.topics = topics;
        this.topicsPattern = topicsPattern;
        this.entryReadBatchSize = entryReadBatchSize;
        this.targetNumSplits = targetNumSplits;
        this.maxSplitMessageQueueSize = maxSplitMessageQueueSize;
        this.maxSplitEntryQueueSize = maxSplitEntryQueueSize;
        this.maxMessageSize = maxMessageSize;
        this.statsProvider = statsProvider;
        this.statsProviderConfigs = statsProviderConfigs;
        this.namespaceDelimiterRewriteEnable = namespaceDelimiterRewriteEnable;
        this.rewriteNamespaceDelimiter = rewriteNamespaceDelimiter;
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
        this.offloadersDirectory = offloadersDirectory;
        this.offloaderProperties = offloaderProperties;
        this.bookkeeperThrottleValue = bookkeeperThrottleValue;
        this.bookkeeperNumIOThreads = bookkeeperNumIOThreads;
        this.bookkeeperNumWorkerThreads = bookkeeperNumWorkerThreads;
        this.managedLedgerCacheSizeMB = managedLedgerCacheSizeMB;
        this.managedLedgerNumWorkerThreads = managedLedgerNumWorkerThreads;
        this.managedLedgerNumSchedulerThreads = managedLedgerNumSchedulerThreads;
        this.partitionDiscoveryIntervalMillis = partitionDiscoveryIntervalMillis;
        this.failOnDataLoss = failOnDataLoss;
        this.clientCacheSize = clientCacheSize;
        this.flushOnCheckpoint = flushOnCheckpoint;
        this.failOnWrite = failOnWrite;
        this.pollTimeoutMs = pollTimeoutMs;
        this.commitMaxRetries = commitMaxRetries;
    }

    public ConnectorConfig() {
    }
}

