/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.pulsar;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;

public class InputLedger
implements Serializable,
Comparable<InputLedger> {
    private String topic;
    private long ledgerId;
    private long startEntryId;
    private long endEntryId;
    private UUID uuid;
    private Map<String, String> offloaderDrvierMeta;

    public long ledgerSize() {
        return this.endEntryId - this.startEntryId + 1L;
    }

    public boolean isOffloadedLedger() {
        return this.uuid != null;
    }

    @Override
    public int compareTo(@NotNull InputLedger o) {
        return this.ledgerSize() > o.ledgerSize() ? 1 : (this.ledgerSize() == o.ledgerSize() ? 0 : -1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("ledger", this.ledgerId).add("startEntryId", this.startEntryId).add("endEntryId", this.endEntryId).add("size", this.ledgerSize()).toString();
    }

    public String getTopic() {
        return this.topic;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getStartEntryId() {
        return this.startEntryId;
    }

    public long getEndEntryId() {
        return this.endEntryId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Map<String, String> getOffloaderDrvierMeta() {
        return this.offloaderDrvierMeta;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setLedgerId(long ledgerId) {
        this.ledgerId = ledgerId;
    }

    public void setStartEntryId(long startEntryId) {
        this.startEntryId = startEntryId;
    }

    public void setEndEntryId(long endEntryId) {
        this.endEntryId = endEntryId;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setOffloaderDrvierMeta(Map<String, String> offloaderDrvierMeta) {
        this.offloaderDrvierMeta = offloaderDrvierMeta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputLedger)) {
            return false;
        }
        InputLedger other = (InputLedger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        if (this.getLedgerId() != other.getLedgerId()) {
            return false;
        }
        if (this.getStartEntryId() != other.getStartEntryId()) {
            return false;
        }
        if (this.getEndEntryId() != other.getEndEntryId()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Map<String, String> this$offloaderDrvierMeta = this.getOffloaderDrvierMeta();
        Map<String, String> other$offloaderDrvierMeta = other.getOffloaderDrvierMeta();
        return !(this$offloaderDrvierMeta == null ? other$offloaderDrvierMeta != null : !((Object)this$offloaderDrvierMeta).equals(other$offloaderDrvierMeta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputLedger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        long $ledgerId = this.getLedgerId();
        result = result * 59 + (int)($ledgerId >>> 32 ^ $ledgerId);
        long $startEntryId = this.getStartEntryId();
        result = result * 59 + (int)($startEntryId >>> 32 ^ $startEntryId);
        long $endEntryId = this.getEndEntryId();
        result = result * 59 + (int)($endEntryId >>> 32 ^ $endEntryId);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Map<String, String> $offloaderDrvierMeta = this.getOffloaderDrvierMeta();
        result = result * 59 + ($offloaderDrvierMeta == null ? 43 : ((Object)$offloaderDrvierMeta).hashCode());
        return result;
    }

    public InputLedger(String topic, long ledgerId, long startEntryId, long endEntryId, UUID uuid, Map<String, String> offloaderDrvierMeta) {
        this.topic = topic;
        this.ledgerId = ledgerId;
        this.startEntryId = startEntryId;
        this.endEntryId = endEntryId;
        this.uuid = uuid;
        this.offloaderDrvierMeta = offloaderDrvierMeta;
    }
}

