/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.pulsar;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.common.policies.data.OffloadPolicies;

public class ConnectorUtils {
    public static <T> T createInstance(String userClassName, Class<T> xface, ClassLoader classLoader) {
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("User class must be in class path", cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(userClassName + " not " + xface.getName());
        }
        Class<T> tCls = theCls.asSubclass(xface);
        try {
            Constructor<T> meth = tCls.getDeclaredConstructor(new Class[0]);
            return meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must a public constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
    }

    public static OffloadPolicies getProperties(Map<String, String> configMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return OffloadPolicies.create((Properties)properties);
    }
}

