/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pulsar.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.pulsar.auth.AbstractPulsarClientAuntenticationService;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;

@Tags(value={"Pulsar", "client", "security", "authentication", "JWT"})
@CapabilityDescription(value="Implementation with JSON Web Token (JWT) Authentication of the PulsarClientAuthenticationService. Provides Pulsar clients with the ability to authenticate against a secured Apache Pulsar broker endpoint.")
public class PulsarClientJwtAuthenticationService
extends AbstractPulsarClientAuntenticationService {
    public static final PropertyDescriptor JWT_TOKEN = new PropertyDescriptor.Builder().name("The JSON Web Token").description("The raw signed JWT string").defaultValue((String)null).addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).build();
    private static final List<PropertyDescriptor> properties;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @Override
    public Authentication getAuthentication() {
        return AuthenticationFactory.token((String)this.configContext.getProperty(JWT_TOKEN).getValue());
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(TRUST_CERTIFICATE);
        props.add(JWT_TOKEN);
        properties = Collections.unmodifiableList(props);
    }
}

