/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pulsar.auth;

import java.io.File;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.pulsar.auth.PulsarClientAuthenticationService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.pulsar.client.api.Authentication;

public abstract class AbstractPulsarClientAuntenticationService
extends AbstractControllerService
implements PulsarClientAuthenticationService {
    public static final PropertyDescriptor TRUST_CERTIFICATE = new PropertyDescriptor.Builder().name("Trusted Certificate Filename").description("The fully-qualified filename of the Trusted certificate.").defaultValue((String)null).addValidator(AbstractPulsarClientAuntenticationService.createFileExistsAndReadableValidator()).sensitive(false).build();
    protected ConfigurationContext configContext;

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.configContext = context;
    }

    public String getTlsTrustCertsFilePath() {
        return this.configContext.getProperty(TRUST_CERTIFICATE).getValue();
    }

    public abstract Authentication getAuthentication();

    protected static Validator createFileExistsAndReadableValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                File file = new File(input);
                boolean valid = file.exists() && file.canRead();
                String explanation = valid ? null : "File " + String.valueOf(file) + " does not exist or cannot be read";
                return new ValidationResult.Builder().subject(subject).input(input).valid(valid).explanation(explanation).build();
            }
        };
    }
}

