/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pulsar.validator;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.processor.util.StandardValidators;

public class PulsarBrokerUrlValidator
implements Validator {
    public static final String MALFORMED_URL = " isn't a valid URL";
    public static final String UNSUPPORTED_PROTOCOL = " isn't a supported protocol";

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        boolean valid = true;
        String explanation = null;
        try {
            String protocol = input.substring(0, input.indexOf(":"));
            if (PulsarBrokerUrlValidator.isSupportedProtocol(protocol)) {
                String hostAndPort = input.substring(input.lastIndexOf("/"), input.length());
                return StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR.validate(subject, hostAndPort, context);
            }
            valid = false;
            explanation = UNSUPPORTED_PROTOCOL;
        }
        catch (StringIndexOutOfBoundsException e) {
            valid = false;
            explanation = MALFORMED_URL;
        }
        return new ValidationResult.Builder().subject(subject).input(input).valid(valid).explanation(explanation).build();
    }

    private static final boolean isSupportedProtocol(String s) {
        return StringUtils.isNotBlank((CharSequence)s) && (s.equalsIgnoreCase("pulsar") || s.equalsIgnoreCase("pulsar+ssl"));
    }
}

