/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pulsar.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.pulsar.auth.AbstractPulsarClientAuntenticationService;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;

@Tags(value={"Pulsar", "client", "security", "authentication", "TLS"})
@CapabilityDescription(value="Implementation with TLS Authentication of the PulsarClientAuthenticationService. Provides Pulsar clients with the ability to authenticate against a secured Apache Pulsar broker endpoint.")
public class PulsarClientTlsAuthenticationService
extends AbstractPulsarClientAuntenticationService {
    public static final PropertyDescriptor CLIENT_CERTIFICATE = new PropertyDescriptor.Builder().name("Client Certificate").description("The fully-qualified filename of the client certificate.").defaultValue(null).addValidator(PulsarClientTlsAuthenticationService.createFileExistsAndReadableValidator()).sensitive(false).build();
    public static final PropertyDescriptor CLIENT_KEY = new PropertyDescriptor.Builder().name("Client Key").description("The fully-qualified filename of the client private key.").defaultValue(null).addValidator(PulsarClientTlsAuthenticationService.createFileExistsAndReadableValidator()).sensitive(false).build();
    private static final List<PropertyDescriptor> properties;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @Override
    public Authentication getAuthentication() {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", this.configContext.getProperty(CLIENT_CERTIFICATE).getValue());
        authParams.put("tlsKeyFile", this.configContext.getProperty(CLIENT_KEY).getValue());
        try {
            return AuthenticationFactory.create((String)AuthenticationTls.class.getName(), authParams);
        }
        catch (PulsarClientException.UnsupportedAuthenticationException e) {
            this.getLogger().error("Unable to authenticate", (Throwable)e);
            return null;
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(TRUST_CERTIFICATE);
        props.add(CLIENT_CERTIFICATE);
        props.add(CLIENT_KEY);
        properties = Collections.unmodifiableList(props);
    }
}

