/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pulsar.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.pulsar.auth.AbstractPulsarClientAuntenticationService;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationAthenz;

@Tags(value={"Pulsar", "client", "security", "authentication", "Athenz"})
@CapabilityDescription(value="Implementation with Athenz Authentication of the PulsarClientAuthenticationService. Provides Pulsar clients with the ability to authenticate against a secured Apache Pulsar broker endpoint.")
public class PulsarClientAthenzAuthenticationService
extends AbstractPulsarClientAuntenticationService {
    public static final PropertyDescriptor TENANT_DOMAIN = new PropertyDescriptor.Builder().name("The tenant domain name").description("The domain name for this tenant").defaultValue(null).addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(false).build();
    public static final PropertyDescriptor TENANT_SERVICE = new PropertyDescriptor.Builder().name("The tenant service name").description("The service name for this tenant").defaultValue(null).addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(false).build();
    public static final PropertyDescriptor PROVIDER_DOMAIN = new PropertyDescriptor.Builder().name("The provider domain").description("The provider domain name").defaultValue(null).addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(false).build();
    public static final PropertyDescriptor TENANT_PRIVATE_KEY_FILE = new PropertyDescriptor.Builder().name("Tenants Private Key Filename").description("The fully-qualified filename of the tenant's private key.").defaultValue(null).addValidator(PulsarClientAthenzAuthenticationService.createFileExistsAndReadableValidator()).required(true).sensitive(false).build();
    public static final PropertyDescriptor TENANT_PRIVATE_KEY_ID = new PropertyDescriptor.Builder().name("Tenants Private Key Id").description("The id of tenant's private key.").defaultValue("0").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).sensitive(false).build();
    public static final PropertyDescriptor AUTO_PREFETCH_ENABLED = new PropertyDescriptor.Builder().name("Auto Prefetch Enabled").description("Specifies whether or not ZTS auto prefetching is enabled.").defaultValue("false").allowableValues(new String[]{"true", "false"}).required(false).sensitive(false).build();
    public static final PropertyDescriptor ATHENZ_CONF_PATH = new PropertyDescriptor.Builder().name("Pulsar Athenz Conf Path").description("The fully-qualified filename of the Pulsar Athenz configuration file.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).required(false).sensitive(false).build();
    public static final PropertyDescriptor PRINCIPAL_HEADER = new PropertyDescriptor.Builder().name("Principal Header").description("Header name of Principal Token.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).sensitive(false).build();
    public static final PropertyDescriptor ROLE_HEADER = new PropertyDescriptor.Builder().name("Role Header").description("Header name of Role Token.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).sensitive(false).build();
    public static final PropertyDescriptor ZTS_URL = new PropertyDescriptor.Builder().name("ZTS URL").description("The ZTS Server URL.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).sensitive(false).build();
    private static final List<PropertyDescriptor> properties;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @Override
    public Authentication getAuthentication() {
        HashMap<String, String> authParams = new HashMap<String, String>();
        this.putAuthParamIfSet(authParams, "tenantDomain", this.configContext.getProperty(TENANT_DOMAIN));
        this.putAuthParamIfSet(authParams, "tenantService", this.configContext.getProperty(TENANT_SERVICE));
        this.putAuthParamIfSet(authParams, "providerDomain", this.configContext.getProperty(PROVIDER_DOMAIN));
        this.putAuthParamIfSet(authParams, "privateKey", this.configContext.getProperty(TENANT_PRIVATE_KEY_FILE));
        this.putAuthParamIfSet(authParams, "keyId", this.configContext.getProperty(TENANT_PRIVATE_KEY_ID));
        this.putAuthParamIfSet(authParams, "autoPrefetchEnabled", this.configContext.getProperty(AUTO_PREFETCH_ENABLED));
        this.putAuthParamIfSet(authParams, "athenzConfPath", this.configContext.getProperty(ATHENZ_CONF_PATH));
        this.putAuthParamIfSet(authParams, "principalHeader", this.configContext.getProperty(PRINCIPAL_HEADER));
        this.putAuthParamIfSet(authParams, "roleHeader", this.configContext.getProperty(ROLE_HEADER));
        this.putAuthParamIfSet(authParams, "ztsUrl", this.configContext.getProperty(ZTS_URL));
        try {
            return AuthenticationFactory.create((String)AuthenticationAthenz.class.getName(), authParams);
        }
        catch (PulsarClientException.UnsupportedAuthenticationException e) {
            this.getLogger().error("Unable to authenticate", (Throwable)e);
            return null;
        }
    }

    private void putAuthParamIfSet(Map<String, String> authParams, String key, PropertyValue value) {
        if (value.isSet()) {
            authParams.put(key, value.getValue());
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(TRUST_CERTIFICATE);
        props.add(TENANT_DOMAIN);
        props.add(TENANT_SERVICE);
        props.add(PROVIDER_DOMAIN);
        props.add(TENANT_PRIVATE_KEY_FILE);
        props.add(TENANT_PRIVATE_KEY_ID);
        props.add(AUTO_PREFETCH_ENABLED);
        props.add(ATHENZ_CONF_PATH);
        props.add(PRINCIPAL_HEADER);
        props.add(ROLE_HEADER);
        props.add(ZTS_URL);
        properties = Collections.unmodifiableList(props);
    }
}

