/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.source;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.connector.pulsar.source.PulsarSource;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.table.source.PulsarReadableMetadata;
import org.apache.flink.connector.pulsar.table.source.PulsarTableDeserializationSchemaFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.SubscriptionType;

public class PulsarTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private static final String FORMAT_METADATA_PREFIX = "value.";
    private final PulsarTableDeserializationSchemaFactory deserializationSchemaFactory;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormatForReadingMetadata;
    private final List<String> topics;
    private final Properties properties;
    private final StartCursor startCursor;
    private final SubscriptionType subscriptionType;

    public PulsarTableSource(PulsarTableDeserializationSchemaFactory deserializationSchemaFactory, DecodingFormat<DeserializationSchema<RowData>> decodingFormatForReadingMetadata, List<String> topics, Properties properties, StartCursor startCursor, SubscriptionType subscriptionType) {
        this.deserializationSchemaFactory = (PulsarTableDeserializationSchemaFactory)Preconditions.checkNotNull((Object)deserializationSchemaFactory);
        this.decodingFormatForReadingMetadata = (DecodingFormat)Preconditions.checkNotNull(decodingFormatForReadingMetadata);
        this.topics = topics;
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
        this.startCursor = (StartCursor)Preconditions.checkNotNull((Object)startCursor);
        this.subscriptionType = (SubscriptionType)((Object)Preconditions.checkNotNull((Object)((Object)subscriptionType)));
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormatForReadingMetadata.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        PulsarDeserializationSchema<RowData> deserializationSchema = this.deserializationSchemaFactory.createPulsarDeserialization(context);
        PulsarSource<RowData> source = PulsarSource.builder().setTopics(this.topics).setStartCursor(this.startCursor).setDeserializationSchema(deserializationSchema).setSubscriptionType(this.subscriptionType).setProperties(this.properties).build();
        return SourceProvider.of(source);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> allMetadataMap = new LinkedHashMap<String, DataType>();
        this.decodingFormatForReadingMetadata.listReadableMetadata().forEach((key, value) -> allMetadataMap.put(FORMAT_METADATA_PREFIX + key, (DataType)value));
        Stream.of(PulsarReadableMetadata.ReadableMetadata.values()).forEachOrdered(m3 -> allMetadataMap.putIfAbsent(m3.key, m3.dataType));
        return allMetadataMap;
    }

    public void applyReadableMetadata(List<String> allMetadataKeys, DataType producedDataType) {
        List formatMetadataKeys = allMetadataKeys.stream().filter(k -> k.startsWith(FORMAT_METADATA_PREFIX)).collect(Collectors.toList());
        ArrayList<String> connectorMetadataKeys = new ArrayList<String>(allMetadataKeys);
        connectorMetadataKeys.removeAll(formatMetadataKeys);
        Map formatMetadata = this.decodingFormatForReadingMetadata.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = formatMetadataKeys.stream().map(k -> k.substring(FORMAT_METADATA_PREFIX.length())).collect(Collectors.toList());
            this.decodingFormatForReadingMetadata.applyReadableMetadata(requestedFormatMetadataKeys);
        }
        this.deserializationSchemaFactory.setConnectorMetadataKeys(connectorMetadataKeys);
        this.deserializationSchemaFactory.setProducedDataType(producedDataType);
    }

    public String asSummaryString() {
        return "Pulsar table source";
    }

    public DynamicTableSource copy() {
        PulsarTableSource copy = new PulsarTableSource(this.deserializationSchemaFactory, this.decodingFormatForReadingMetadata, this.topics, this.properties, this.startCursor, this.subscriptionType);
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarTableSource that = (PulsarTableSource)o;
        return Objects.equals(this.deserializationSchemaFactory, that.deserializationSchemaFactory) && Objects.equals(this.decodingFormatForReadingMetadata, that.decodingFormatForReadingMetadata) && Objects.equals(this.topics, that.topics) && Objects.equals(this.properties, that.properties) && Objects.equals(this.startCursor, that.startCursor) && this.subscriptionType == that.subscriptionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deserializationSchemaFactory, this.decodingFormatForReadingMetadata, this.topics, this.properties, this.startCursor, this.subscriptionType});
    }
}

