/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.catalog.impl;

import com.google.protobuf.Descriptors;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.pulsar.table.catalog.impl.IncompatibleSchemaException;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaTranslator.class);
    public static final String SINGLE_FIELD_FIELD_NAME = "value";
    private final boolean useMetadataFields;

    public SchemaTranslator(boolean useMetadataFields) {
        this.useMetadataFields = useMetadataFields;
    }

    public Schema pulsarSchemaToFlinkSchema(SchemaInfo pulsarSchema) throws IncompatibleSchemaException {
        DataType fieldsDataType = this.pulsarSchemaToPhysicalFields(pulsarSchema);
        Schema.Builder schemaBuilder = Schema.newBuilder().fromRowDataType(fieldsDataType);
        if (this.useMetadataFields) {
            throw new UnsupportedOperationException("Querying Pulsar Metadata is not supported yet");
        }
        return schemaBuilder.build();
    }

    public DataType pulsarSchemaToPhysicalFields(SchemaInfo schemaInfo) throws IncompatibleSchemaException {
        ArrayList<DataTypes.Field> mainSchema = new ArrayList<DataTypes.Field>();
        DataType dataType = this.schemaInfo2SqlType(schemaInfo);
        if (dataType instanceof FieldsDataType) {
            FieldsDataType fieldsDataType = (FieldsDataType)dataType;
            RowType rowType = (RowType)fieldsDataType.getLogicalType();
            List fieldNames = rowType.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                LogicalType logicalType = rowType.getTypeAt(i);
                DataTypes.Field field = DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType));
                mainSchema.add(field);
            }
        } else {
            mainSchema.add(DataTypes.FIELD((String)SINGLE_FIELD_FIELD_NAME, (DataType)dataType));
        }
        return DataTypes.ROW((DataTypes.Field[])mainSchema.toArray(new DataTypes.Field[0]));
    }

    public DataType schemaInfo2SqlType(SchemaInfo si) throws IncompatibleSchemaException {
        switch (si.getType()) {
            case NONE: 
            case BYTES: {
                return DataTypes.BYTES();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case LOCAL_DATE: {
                return DataTypes.DATE();
            }
            case LOCAL_TIME: {
                return DataTypes.TIME();
            }
            case STRING: {
                return DataTypes.STRING();
            }
            case LOCAL_DATE_TIME: {
                return DataTypes.TIMESTAMP((int)3);
            }
            case INT8: {
                return DataTypes.TINYINT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case INT32: {
                return DataTypes.INT();
            }
            case INT64: {
                return DataTypes.BIGINT();
            }
            case INT16: {
                return DataTypes.SMALLINT();
            }
            case AVRO: 
            case JSON: {
                String avroSchemaString = new String(si.getSchema(), StandardCharsets.UTF_8);
                return AvroSchemaConverter.convertToDataType((String)avroSchemaString);
            }
            case PROTOBUF_NATIVE: {
                Descriptors.Descriptor descriptor = ((GenericProtobufNativeSchema)GenericProtobufNativeSchema.of(si)).getProtobufNativeSchema();
                return SchemaTranslator.protoDescriptorToSqlType(descriptor);
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support %s currently.", new Object[]{si.getType()}));
    }

    public static DataType protoDescriptorToSqlType(Descriptors.Descriptor descriptor) throws IncompatibleSchemaException {
        ArrayList<DataTypes.Field> fields = new ArrayList<DataTypes.Field>();
        List<Descriptors.FieldDescriptor> protoFields = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : protoFields) {
            DataType fieldType = SchemaTranslator.protoFieldDescriptorToSqlType(fieldDescriptor);
            fields.add(DataTypes.FIELD((String)fieldDescriptor.getName(), (DataType)fieldType));
        }
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("No FieldDescriptors found");
        }
        return DataTypes.ROW((DataTypes.Field[])fields.toArray(new DataTypes.Field[0]));
    }

    private static DataType protoFieldDescriptorToSqlType(Descriptors.FieldDescriptor field) throws IncompatibleSchemaException {
        DataType dataType;
        Descriptors.FieldDescriptor.JavaType type = field.getJavaType();
        switch (type) {
            case BOOLEAN: {
                dataType = DataTypes.BOOLEAN();
                break;
            }
            case BYTE_STRING: {
                dataType = DataTypes.BYTES();
                break;
            }
            case DOUBLE: {
                dataType = DataTypes.DOUBLE();
                break;
            }
            case ENUM: {
                dataType = DataTypes.STRING();
                break;
            }
            case FLOAT: {
                dataType = DataTypes.FLOAT();
                break;
            }
            case INT: {
                dataType = DataTypes.INT();
                break;
            }
            case LONG: {
                dataType = DataTypes.BIGINT();
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msg = field.getMessageType();
                if (field.isMapField()) {
                    dataType = DataTypes.MAP((DataType)SchemaTranslator.protoFieldDescriptorToSqlType(msg.findFieldByName("key")), (DataType)SchemaTranslator.protoFieldDescriptorToSqlType(msg.findFieldByName(SINGLE_FIELD_FIELD_NAME)));
                    break;
                }
                dataType = SchemaTranslator.protoDescriptorToSqlType(field.getMessageType());
                break;
            }
            case STRING: {
                dataType = DataTypes.STRING();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type.toString() + " for FieldDescriptor: " + field.toString());
            }
        }
        if (field.isRepeated() && !field.isMapField()) {
            dataType = DataTypes.ARRAY((DataType)dataType);
        }
        return dataType;
    }

    public String decideDefaultFlinkFormat(SchemaInfo pulsarSchemaInfo) {
        String formatIdentifier = "raw";
        switch (pulsarSchemaInfo.getType()) {
            case JSON: {
                formatIdentifier = "json";
                break;
            }
            case AVRO: {
                formatIdentifier = "avro";
                break;
            }
            case PROTOBUF_NATIVE: 
            case PROTOBUF: 
            case AUTO_CONSUME: 
            case AUTO: 
            case AUTO_PUBLISH: {
                LOG.error("Can't decide format for {} schema", (Object)pulsarSchemaInfo.getType().toString());
                throw new UnsupportedOperationException(String.format("Can't decide format for %s schema", pulsarSchemaInfo.getType().toString()));
            }
        }
        return formatIdentifier;
    }
}

