/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table;

import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.flink.connector.pulsar.table.PulsarTableOptionUtils;
import org.apache.flink.connector.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.types.RowKind;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.TopicName;

public class PulsarTableValidationUtils {
    private PulsarTableValidationUtils() {
    }

    public static void validatePrimaryKeyConstraints(ObjectIdentifier tableName, int[] primaryKeyIndexes, FactoryUtil.TableFactoryHelper helper) {
        DecodingFormat<DeserializationSchema<RowData>> format = PulsarTableOptionUtils.getValueDecodingFormat(helper);
        if (primaryKeyIndexes.length > 0 && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            throw new ValidationException(String.format("The Pulsar table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), format));
        }
    }

    public static void validateTableSourceOptions(ReadableConfig tableOptions) {
        PulsarTableValidationUtils.validateTopicsConfigs(tableOptions);
        PulsarTableValidationUtils.validateStartCursorConfigs(tableOptions);
        PulsarTableValidationUtils.validateSubscriptionTypeConfigs(tableOptions);
        PulsarTableValidationUtils.validateKeyFormatConfigs(tableOptions);
    }

    public static void validateTableSinkOptions(ReadableConfig tableOptions) {
        PulsarTableValidationUtils.validateTopicsConfigs(tableOptions);
        PulsarTableValidationUtils.validateKeyFormatConfigs(tableOptions);
        PulsarTableValidationUtils.validateSinkRoutingConfigs(tableOptions);
    }

    protected static void validateTopicsConfigs(ReadableConfig tableOptions) {
        if (((List)tableOptions.get(PulsarTableOptions.TOPICS)).isEmpty()) {
            throw new ValidationException("The topics list should not be empty.");
        }
        for (String topic : (List)tableOptions.get(PulsarTableOptions.TOPICS)) {
            if (TopicName.isValid(topic)) continue;
            throw new ValidationException(String.format("The topics name %s is not a valid topic name.", topic));
        }
    }

    protected static void validateStartCursorConfigs(ReadableConfig tableOptions) {
        if (tableOptions.getOptional(PulsarTableOptions.SOURCE_START_FROM_MESSAGE_ID).isPresent() && tableOptions.getOptional(PulsarTableOptions.SOURCE_START_FROM_PUBLISH_TIME).isPresent()) {
            throw new ValidationException(String.format("Only one of %s and %s can be specified. Detected both of them", PulsarTableOptions.SOURCE_START_FROM_MESSAGE_ID, PulsarTableOptions.SOURCE_START_FROM_PUBLISH_TIME));
        }
    }

    protected static void validateSubscriptionTypeConfigs(ReadableConfig tableOptions) {
        SubscriptionType subscriptionType = (SubscriptionType)((Object)tableOptions.get(PulsarTableOptions.SOURCE_SUBSCRIPTION_TYPE));
        if (subscriptionType == SubscriptionType.Failover || subscriptionType == SubscriptionType.Key_Shared) {
            throw new ValidationException(String.format("Only %s and %s SubscriptionType is supported. ", new Object[]{SubscriptionType.Exclusive, SubscriptionType.Shared}));
        }
    }

    protected static void validateKeyFormatConfigs(ReadableConfig tableOptions) {
        Optional optionalKeyFormat = tableOptions.getOptional(PulsarTableOptions.KEY_FORMAT);
        Optional optionalKeyFields = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS);
        if (!optionalKeyFormat.isPresent() && optionalKeyFields.isPresent()) {
            throw new ValidationException(String.format("The option '%s' can only be declared if a key format is defined using '%s'.", PulsarTableOptions.KEY_FIELDS.key(), PulsarTableOptions.KEY_FORMAT.key()));
        }
        if (optionalKeyFormat.isPresent() && (!optionalKeyFields.isPresent() || ((List)optionalKeyFields.get()).size() == 0)) {
            throw new ValidationException(String.format("A key format '%s' requires the declaration of one or more of key fields using '%s'.", PulsarTableOptions.KEY_FORMAT.key(), PulsarTableOptions.KEY_FIELDS.key()));
        }
    }

    protected static void validateSinkRoutingConfigs(ReadableConfig tableOptions) {
        if (tableOptions.getOptional(PulsarTableOptions.SINK_TOPIC_ROUTING_MODE).orElse(TopicRoutingMode.ROUND_ROBIN) == TopicRoutingMode.CUSTOM) {
            throw new ValidationException(String.format("Only  %s and %s can be used. For %s, please use sink.custom-topic-router forcustom topic router and do not set this config.", new Object[]{TopicRoutingMode.ROUND_ROBIN, TopicRoutingMode.MESSAGE_KEY_HASH, TopicRoutingMode.CUSTOM}));
        }
        if (tableOptions.getOptional(PulsarTableOptions.SINK_CUSTOM_TOPIC_ROUTER).isPresent() && tableOptions.getOptional(PulsarTableOptions.SINK_TOPIC_ROUTING_MODE).isPresent()) {
            throw new ValidationException(String.format("Only one of %s and %s can be specified. Detected both of them", PulsarTableOptions.SINK_CUSTOM_TOPIC_ROUTER, PulsarTableOptions.SINK_TOPIC_ROUTING_MODE));
        }
    }
}

