/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import javax.annotation.Nullable;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.NormalSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.pulsar.client.api.SubscriptionType;

public final class SplitAssignerFactory {
    private SplitAssignerFactory() {
    }

    public static SplitAssigner create(StopCursor stopCursor, SourceConfiguration sourceConfiguration) {
        return SplitAssignerFactory.create(stopCursor, sourceConfiguration, null);
    }

    public static SplitAssigner create(StopCursor stopCursor, SourceConfiguration sourceConfiguration, @Nullable PulsarSourceEnumState sourceEnumState) {
        SubscriptionType subscriptionType = sourceConfiguration.getSubscriptionType();
        if (subscriptionType == SubscriptionType.Exclusive || subscriptionType == SubscriptionType.Failover || subscriptionType == SubscriptionType.Key_Shared) {
            if (sourceEnumState == null) {
                return new NormalSplitAssigner(stopCursor, sourceConfiguration);
            }
            return new NormalSplitAssigner(stopCursor, sourceConfiguration, sourceEnumState);
        }
        if (subscriptionType == SubscriptionType.Shared) {
            if (sourceEnumState == null) {
                return new SharedSplitAssigner(stopCursor, sourceConfiguration);
            }
            return new SharedSplitAssigner(stopCursor, sourceConfiguration, sourceEnumState);
        }
        throw new IllegalArgumentException("We don't support this subscription type: " + (Object)((Object)subscriptionType));
    }
}

