/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.topic.metadata;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.topic.TopicExtractor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.util.ExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;

@Internal
public class NotExistedTopicMetadataProvider
implements TopicExtractor.TopicMetadataProvider {
    private final PulsarAdmin pulsarAdmin;
    private final boolean enableTopicAutoCreation;
    private final int defaultTopicPartitions;

    public NotExistedTopicMetadataProvider(PulsarAdmin pulsarAdmin, SinkConfiguration sinkConfiguration) {
        this.pulsarAdmin = pulsarAdmin;
        this.enableTopicAutoCreation = sinkConfiguration.isEnableTopicAutoCreation();
        this.defaultTopicPartitions = sinkConfiguration.getDefaultTopicPartitions();
    }

    @Override
    public TopicMetadata query(String topic) throws PulsarAdminException {
        try {
            PartitionedTopicMetadata meta = this.pulsarAdmin.topics().getPartitionedTopicMetadata(topic);
            return new TopicMetadata(topic, meta.partitions);
        }
        catch (PulsarAdminException e) {
            if (ExceptionUtils.findThrowable((Throwable)e, PulsarAdminException.NotFoundException.class).isPresent() && this.enableTopicAutoCreation) {
                this.createTopic(topic);
                return new TopicMetadata(topic, this.defaultTopicPartitions);
            }
            throw e;
        }
    }

    private void createTopic(String topic) throws PulsarAdminException {
        if (this.defaultTopicPartitions == 0) {
            this.pulsarAdmin.topics().createNonPartitionedTopic(topic);
        } else {
            this.pulsarAdmin.topics().createPartitionedTopic(topic, this.defaultTopicPartitions);
        }
    }
}

