/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.topic.metadata;

import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.topic.TopicExtractor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;

@Internal
public class CachedTopicMetadataProvider
implements TopicExtractor.TopicMetadataProvider {
    private final PulsarAdmin pulsarAdmin;
    private final Cache<String, TopicMetadata> metadataCache;

    public CachedTopicMetadataProvider(PulsarAdmin pulsarAdmin, SinkConfiguration sinkConfiguration) {
        this.pulsarAdmin = pulsarAdmin;
        long refreshInterval = sinkConfiguration.getTopicMetadataRefreshInterval();
        this.metadataCache = refreshInterval <= 0L ? null : CacheBuilder.newBuilder().expireAfterWrite(refreshInterval, TimeUnit.MILLISECONDS).maximumSize(1000L).build();
    }

    @Override
    public TopicMetadata query(String topic) throws PulsarAdminException {
        TopicMetadata metadata;
        TopicMetadata topicMetadata = metadata = this.metadataCache == null ? null : (TopicMetadata)this.metadataCache.getIfPresent((Object)topic);
        if (metadata == null) {
            PartitionedTopicMetadata meta = this.pulsarAdmin.topics().getPartitionedTopicMetadata(topic);
            metadata = new TopicMetadata(topic, meta.partitions);
            if (this.metadataCache != null) {
                this.metadataCache.put((Object)topic, (Object)metadata);
            }
        }
        return metadata;
    }
}

