/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.ProducerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TypedMessageBuilderImpl;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.common.protocol.schema.SchemaHash;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public abstract class ProducerBase<T>
extends HandlerState
implements Producer<T> {
    protected final CompletableFuture<Producer<T>> producerCreatedFuture;
    protected final ProducerConfigurationData conf;
    protected final Schema<T> schema;
    protected final ProducerInterceptors interceptors;
    protected final ConcurrentOpenHashMap<SchemaHash, byte[]> schemaCache;
    protected volatile MultiSchemaMode multiSchemaMode = MultiSchemaMode.Auto;

    protected ProducerBase(PulsarClientImpl client, String topic, ProducerConfigurationData conf, CompletableFuture<Producer<T>> producerCreatedFuture, Schema<T> schema, ProducerInterceptors interceptors) {
        super(client, topic);
        this.producerCreatedFuture = producerCreatedFuture;
        this.conf = conf;
        this.schema = schema;
        this.interceptors = interceptors;
        this.schemaCache = new ConcurrentOpenHashMap();
        if (!conf.isMultiSchema()) {
            this.multiSchemaMode = MultiSchemaMode.Disabled;
        }
    }

    @Override
    public MessageId send(T message) throws PulsarClientException {
        return this.newMessage().value(message).send();
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(T message) {
        try {
            return this.newMessage().value(message).sendAsync();
        }
        catch (SchemaSerializationException e) {
            return FutureUtil.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(Message<?> message) {
        return this.internalSendAsync(message);
    }

    @Override
    public TypedMessageBuilder<T> newMessage() {
        return new TypedMessageBuilderImpl<T>(this, this.schema);
    }

    @Override
    public <V> TypedMessageBuilder<V> newMessage(Schema<V> schema) {
        Preconditions.checkArgument(schema != null);
        return new TypedMessageBuilderImpl<V>(this, schema);
    }

    @Override
    public TypedMessageBuilder<T> newMessage(Transaction txn) {
        Preconditions.checkArgument(txn instanceof TransactionImpl);
        if (this.conf.getSendTimeoutMs() > 0L) {
            throw new IllegalArgumentException("Only producers disabled sendTimeout are allowed to produce transactional messages");
        }
        return new TypedMessageBuilderImpl<T>(this, this.schema, (TransactionImpl)txn);
    }

    abstract CompletableFuture<MessageId> internalSendAsync(Message<?> var1);

    abstract CompletableFuture<MessageId> internalSendWithTxnAsync(Message<?> var1, Transaction var2);

    @Override
    public MessageId send(Message<?> message) throws PulsarClientException {
        try {
            CompletableFuture<MessageId> sendFuture = this.internalSendAsync(message);
            if (!sendFuture.isDone()) {
                this.triggerFlush();
            }
            return sendFuture.get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    @Override
    public void flush() throws PulsarClientException {
        try {
            this.flushAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    abstract void triggerFlush();

    @Override
    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    @Override
    public abstract CompletableFuture<Void> closeAsync();

    @Override
    public String getTopic() {
        return this.topic;
    }

    public ProducerConfigurationData getConfiguration() {
        return this.conf;
    }

    public CompletableFuture<Producer<T>> producerCreatedFuture() {
        return this.producerCreatedFuture;
    }

    protected Message<?> beforeSend(Message<?> message) {
        if (this.interceptors != null) {
            return this.interceptors.beforeSend(this, message);
        }
        return message;
    }

    protected void onSendAcknowledgement(Message<?> message, MessageId msgId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onSendAcknowledgement(this, message, msgId, exception);
        }
    }

    protected void onPartitionsChange(String topicName, int partitions) {
        if (this.interceptors != null) {
            this.interceptors.onPartitionsChange(topicName, partitions);
        }
    }

    public String toString() {
        return "ProducerBase{topic='" + this.topic + '\'' + '}';
    }

    public static enum MultiSchemaMode {
        Auto,
        Enabled,
        Disabled;

    }
}

