/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.source;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.pulsar.client.api.Message;

public class PulsarReadableMetadata
implements Serializable {
    private static final long serialVersionUID = -4409932324481235973L;
    private final List<String> connectorMetadataKeys;
    private final List<MetadataConverter> metadataConverters;

    public PulsarReadableMetadata(List<String> connectorMetadataKeys) {
        this.connectorMetadataKeys = connectorMetadataKeys;
        this.metadataConverters = this.initializeMetadataConverters();
    }

    private List<MetadataConverter> initializeMetadataConverters() {
        return this.connectorMetadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(m3 -> m3.converter).collect(Collectors.toList());
    }

    public void appendProducedRowWithMetadata(GenericRowData producedRowData, int physicalArity, Message<?> message) {
        for (int metadataPos = 0; metadataPos < this.metadataConverters.size(); ++metadataPos) {
            producedRowData.setField(physicalArity + metadataPos, this.metadataConverters.get(metadataPos).read(message));
        }
    }

    public int getConnectorMetadataArity() {
        return this.metadataConverters.size();
    }

    public static enum ReadableMetadata {
        TOPIC("topic", (DataType)DataTypes.STRING().notNull(), message -> StringData.fromString((String)message.getTopicName())),
        MESSAGE_SIZE("message_size", (DataType)DataTypes.INT().notNull(), message -> message.size()),
        PRODUCER_NAME("producer_name", (DataType)DataTypes.STRING().notNull(), message -> StringData.fromString((String)message.getProducerName())),
        MESSAGE_ID("message_id", (DataType)DataTypes.BYTES().notNull(), message -> message.getMessageId().toByteArray()),
        SEQUENCE_ID("sequenceId", (DataType)DataTypes.BIGINT().notNull(), Message::getSequenceId),
        PUBLISH_TIME("publish_time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), message -> TimestampData.fromEpochMillis((long)message.getPublishTime())),
        EVENT_TIME("event_time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), message -> TimestampData.fromEpochMillis((long)message.getEventTime())),
        PROPERTIES("properties", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).notNull(), message -> {
            HashMap<StringData, StringData> map = new HashMap<StringData, StringData>();
            for (Map.Entry<String, String> e : message.getProperties().entrySet()) {
                map.put(StringData.fromString((String)e.getKey()), StringData.fromString((String)e.getValue()));
            }
            return new GenericMapData(map);
        });

        public final String key;
        public final DataType dataType;
        public final MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(Message<?> var1);
    }
}

