/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.sink;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessageBuilder;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.table.sink.PulsarWritableMetadata;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;

public class PulsarTableSerializationSchema
implements PulsarSerializationSchema<RowData> {
    private static final long serialVersionUID = 7314442107082067836L;
    @Nullable
    private final SerializationSchema<RowData> keySerialization;
    private final RowData.FieldGetter[] keyFieldGetters;
    private final SerializationSchema<RowData> valueSerialization;
    private final RowData.FieldGetter[] valueFieldGetters;
    private final PulsarWritableMetadata writableMetadata;

    public PulsarTableSerializationSchema(@Nullable SerializationSchema<RowData> keySerialization, RowData.FieldGetter[] keyFieldGetters, SerializationSchema<RowData> valueSerialization, RowData.FieldGetter[] valueFieldGetters, PulsarWritableMetadata writableMetadata) {
        this.keySerialization = keySerialization;
        this.keyFieldGetters = (RowData.FieldGetter[])Preconditions.checkNotNull((Object)keyFieldGetters);
        this.valueSerialization = (SerializationSchema)Preconditions.checkNotNull(valueSerialization);
        this.valueFieldGetters = (RowData.FieldGetter[])Preconditions.checkNotNull((Object)valueFieldGetters);
        this.writableMetadata = (PulsarWritableMetadata)Preconditions.checkNotNull((Object)writableMetadata);
    }

    @Override
    public void open(SerializationSchema.InitializationContext initializationContext, PulsarSinkContext sinkContext, SinkConfiguration sinkConfiguration) throws Exception {
        this.valueSerialization.open(initializationContext);
    }

    @Override
    public PulsarMessage<?> serialize(RowData consumedRow, PulsarSinkContext sinkContext) {
        PulsarMessageBuilder<byte[]> messageBuilder = new PulsarMessageBuilder<byte[]>();
        RowKind kind = consumedRow.getRowKind();
        RowData valueRow = PulsarTableSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
        this.writableMetadata.applyWritableMetadataInMessage(consumedRow, messageBuilder);
        if (this.keySerialization != null) {
            RowData keyRow = PulsarTableSerializationSchema.createProjectedRow(consumedRow, RowKind.INSERT, this.keyFieldGetters);
            messageBuilder.keyBytes(this.keySerialization.serialize((Object)keyRow));
        }
        byte[] serializedData = this.valueSerialization.serialize((Object)valueRow);
        messageBuilder.value(Schema.BYTES, serializedData);
        return messageBuilder.build();
    }

    private static RowData createProjectedRow(RowData consumedRow, RowKind kind, RowData.FieldGetter[] fieldGetters) {
        int arity = fieldGetters.length;
        GenericRowData genericRowData = new GenericRowData(kind, arity);
        for (int fieldPos = 0; fieldPos < arity; ++fieldPos) {
            genericRowData.setField(fieldPos, fieldGetters[fieldPos].getFieldOrNull(consumedRow));
        }
        return genericRowData;
    }

    public static interface MetadataConverter
    extends Serializable {
        public Object read(RowData var1, int var2);
    }
}

