/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.catalog;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigBuilder;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigValidator;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalog;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalogConfiguration;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalogFactoryOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class PulsarCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "pulsar-catalog";
    public static final PulsarConfigValidator CATALOG_CONFIG_VALIDATOR = PulsarConfigValidator.builder().build();

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        PulsarConfigBuilder configBuilder = new PulsarConfigBuilder();
        ReadableConfig tableOptions = helper.getOptions();
        configBuilder.set(PulsarOptions.PULSAR_ADMIN_URL, tableOptions.get(PulsarCatalogFactoryOptions.CATALOG_ADMIN_URL));
        configBuilder.set(PulsarOptions.PULSAR_SERVICE_URL, tableOptions.get(PulsarCatalogFactoryOptions.CATALOG_SERVICE_URL));
        if (tableOptions.getOptional(PulsarCatalogFactoryOptions.AUTH_PLUGIN).isPresent()) {
            configBuilder.set(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME, tableOptions.get(PulsarCatalogFactoryOptions.AUTH_PLUGIN));
        }
        if (tableOptions.getOptional(PulsarCatalogFactoryOptions.AUTH_PARAMS).isPresent()) {
            configBuilder.set(PulsarOptions.PULSAR_AUTH_PARAMS, tableOptions.get(PulsarCatalogFactoryOptions.AUTH_PARAMS));
        }
        PulsarCatalogConfiguration catalogConfiguration = configBuilder.build(CATALOG_CONFIG_VALIDATOR, PulsarCatalogConfiguration::new);
        return new PulsarCatalog(context.getName(), catalogConfiguration, (String)helper.getOptions().get(PulsarCatalogFactoryOptions.DEFAULT_DATABASE), (String)helper.getOptions().get(PulsarCatalogFactoryOptions.CATALOG_TENANT));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Stream.of(PulsarCatalogFactoryOptions.CATALOG_ADMIN_URL, PulsarCatalogFactoryOptions.CATALOG_SERVICE_URL, PulsarCatalogFactoryOptions.CATALOG_TENANT, PulsarCatalogFactoryOptions.DEFAULT_DATABASE, PulsarCatalogFactoryOptions.AUTH_PLUGIN, PulsarCatalogFactoryOptions.AUTH_PARAMS).collect(Collectors.toSet());
    }
}

