/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.BasePulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.shaded.guava30.com.google.common.base.Predicates;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;

public class TopicPatternSubscriber
extends BasePulsarSubscriber {
    private static final long serialVersionUID = 3307710093243745104L;
    private final Pattern topicPattern;
    private final RegexSubscriptionMode subscriptionMode;
    private final String namespace;

    public TopicPatternSubscriber(Pattern topicPattern, RegexSubscriptionMode subscriptionMode) {
        this.topicPattern = topicPattern;
        this.subscriptionMode = subscriptionMode;
        TopicName destination = TopicName.get(topicPattern.toString());
        NamespaceName namespaceName = destination.getNamespaceObject();
        this.namespace = namespaceName.toString();
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(PulsarAdmin pulsarAdmin, RangeGenerator rangeGenerator, int parallelism) {
        try {
            return pulsarAdmin.namespaces().getTopics(this.namespace).parallelStream().filter(Predicates.not(TopicNameUtils::isInternal)).filter(this::matchesSubscriptionMode).filter(topic -> this.topicPattern.matcher((CharSequence)topic).find()).map(topic -> this.queryTopicMetadata(pulsarAdmin, (String)topic)).filter(Objects::nonNull).flatMap(metadata -> {
                List<TopicRange> ranges = rangeGenerator.range((TopicMetadata)metadata, parallelism);
                return this.toTopicPartitions((TopicMetadata)metadata, ranges).stream();
            }).collect(Collectors.toSet());
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                return Collections.emptySet();
            }
            throw new IllegalStateException(e);
        }
    }

    private boolean matchesSubscriptionMode(String topic) {
        TopicName topicName = TopicName.get(topic);
        switch (this.subscriptionMode) {
            case PersistentOnly: {
                return topicName.isPersistent();
            }
            case NonPersistentOnly: {
                return !topicName.isPersistent();
            }
        }
        return true;
    }
}

