/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.BasePulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.pulsar.client.admin.PulsarAdmin;

public class TopicListSubscriber
extends BasePulsarSubscriber {
    private static final long serialVersionUID = 6473918213832993116L;
    private final List<String> topics;

    public TopicListSubscriber(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(PulsarAdmin pulsarAdmin, RangeGenerator rangeGenerator, int parallelism) {
        return this.topics.parallelStream().map(topic -> this.queryTopicMetadata(pulsarAdmin, (String)topic)).filter(Objects::nonNull).flatMap(metadata -> {
            List<TopicRange> ranges = rangeGenerator.range((TopicMetadata)metadata, parallelism);
            return this.toTopicPartitions((TopicMetadata)metadata, ranges).stream();
        }).collect(Collectors.toSet());
    }
}

