/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdStopCursor
implements StopCursor {
    private static final long serialVersionUID = -3990454110809274542L;
    private final MessageId messageId;
    private final boolean exclusive;

    public MessageIdStopCursor(MessageId messageId) {
        this(messageId, true);
    }

    public MessageIdStopCursor(MessageId messageId, boolean exclusive) {
        MessageIdImpl id = MessageIdImpl.convertToMessageIdImpl(messageId);
        Preconditions.checkState((!(id instanceof BatchMessageIdImpl) ? 1 : 0) != 0, (Object)"We only support normal message id currently.");
        Preconditions.checkArgument((!MessageId.earliest.equals(id) ? 1 : 0) != 0, (Object)"MessageId.earliest is not supported.");
        Preconditions.checkArgument((!MessageId.latest.equals(id) ? 1 : 0) != 0, (Object)"MessageId.latest is not supported, use LatestMessageStopCursor instead.");
        this.messageId = id;
        this.exclusive = exclusive;
    }

    @Override
    public boolean shouldStop(Message<?> message) {
        MessageId id = message.getMessageId();
        if (this.exclusive) {
            return id.compareTo(this.messageId) > 0;
        }
        return id.compareTo(this.messageId) >= 0;
    }
}

