/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema.factories;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.connector.pulsar.common.schema.factories.BaseStructSchemaFactory;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class JSONSchemaFactory<T>
extends BaseStructSchemaFactory<T> {
    @Override
    public SchemaType type() {
        return SchemaType.JSON;
    }

    @Override
    public Schema<T> createSchema(SchemaInfo info) {
        Class typeClass = PulsarSchemaUtils.decodeClassInfo(info);
        return JSONSchema.of(typeClass, info.getProperties());
    }

    @Override
    public TypeInformation<T> createTypeInfo(SchemaInfo info) {
        try {
            Class decodeClassInfo = PulsarSchemaUtils.decodeClassInfo(info);
            return AvroUtils.getAvroUtils().createAvroTypeInfo(decodeClassInfo);
        }
        catch (Exception e) {
            return super.createTypeInfo(info);
        }
    }
}

