/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ReflectionUtil;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@Internal
public final class PulsarSchema<T>
implements Serializable {
    private static final long serialVersionUID = -2561088131419607555L;
    private transient Schema<T> schema;
    private transient SchemaInfo schemaInfo;
    private String schemaName;
    private byte[] schemaBytes;
    private SchemaType schemaType;
    private Map<String, String> schemaProperties;

    public PulsarSchema(Schema<T> schema) {
        SchemaInfo info = schema.getSchemaInfo();
        SchemaType type = info.getType();
        Preconditions.checkArgument((type != SchemaType.JSON ? 1 : 0) != 0, (Object)"Json Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.AVRO ? 1 : 0) != 0, (Object)"Avro Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.PROTOBUF ? 1 : 0) != 0, (Object)"Protobuf Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.PROTOBUF_NATIVE ? 1 : 0) != 0, (Object)"Protobuf Native Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"Key Value Schema should provide the type class of key and value");
        Class typeClass = ReflectionUtil.getTemplateType1(schema.getClass());
        this.setSchemaInfo(PulsarSchemaUtils.encodeClassInfo(info, typeClass));
    }

    public PulsarSchema(Schema<T> schema, Class<T> typeClass) {
        SchemaInfo info = schema.getSchemaInfo();
        Preconditions.checkArgument((info.getType() != SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"Key Value Schema should provide the type classes of key and value");
        this.validateSchemaInfo(info);
        this.setSchemaInfo(PulsarSchemaUtils.encodeClassInfo(info, typeClass));
    }

    public <K, V> PulsarSchema(Schema<KeyValue<K, V>> kvSchema, Class<K> keyClass, Class<V> valueClass) {
        SchemaInfo info = kvSchema.getSchemaInfo();
        Preconditions.checkArgument((info.getType() == SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"This constructor could only be applied for KeyValueSchema");
        KeyValue<SchemaInfo, SchemaInfo> infoKeyValue = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(info);
        SchemaInfo infoKey = PulsarSchemaUtils.encodeClassInfo(infoKeyValue.getKey(), keyClass);
        this.validateSchemaInfo(infoKey);
        SchemaInfo infoValue = PulsarSchemaUtils.encodeClassInfo(infoKeyValue.getValue(), valueClass);
        this.validateSchemaInfo(infoValue);
        KeyValueEncodingType encodingType = KeyValueSchemaInfo.decodeKeyValueEncodingType(info);
        SchemaInfo encodedInfo = KeyValueSchemaInfo.encodeKeyValueSchemaInfo(info.getName(), infoKey, infoValue, encodingType);
        this.setSchemaInfo(PulsarSchemaUtils.encodeClassInfo(encodedInfo, KeyValue.class));
    }

    private void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schema = PulsarSchemaUtils.createSchema(schemaInfo);
        this.schemaInfo = schemaInfo;
        this.schemaName = schemaInfo.getName();
        this.schemaBytes = schemaInfo.getSchema();
        this.schemaType = schemaInfo.getType();
        this.schemaProperties = schemaInfo.getProperties();
    }

    public Schema<T> getPulsarSchema() {
        if (this.schema == null) {
            this.schema = PulsarSchemaUtils.createSchema(this.getSchemaInfo());
        }
        return this.schema;
    }

    public SchemaInfo getSchemaInfo() {
        if (this.schemaInfo == null) {
            this.schemaInfo = new SchemaInfoImpl(this.schemaName, this.schemaBytes, this.schemaType, this.schemaProperties);
        }
        return this.schemaInfo;
    }

    public Class<T> getRecordClass() {
        return PulsarSchemaUtils.decodeClassInfo(this.getSchemaInfo());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarSchema that = (PulsarSchema)o;
        return Objects.equals((Object)this.schemaType, (Object)that.schemaType) && Arrays.equals(this.schemaBytes, that.schemaBytes) && Objects.equals(this.schemaProperties, that.schemaProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaType, Arrays.hashCode(this.schemaBytes), this.schemaProperties});
    }

    public String toString() {
        return this.getSchemaInfo().toString();
    }

    private void validateSchemaInfo(SchemaInfo info) {
        SchemaType type = info.getType();
        if (type == SchemaType.PROTOBUF || type == SchemaType.PROTOBUF_NATIVE) {
            Preconditions.checkState((boolean)PulsarSchemaUtils.haveProtobuf(), (Object)"protobuf-java should be provided if you use related schema.");
        }
    }
}

