/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;

public abstract class PulsarConfiguration
extends UnmodifiableConfiguration {
    private static final long serialVersionUID = 3050894147145572345L;

    protected PulsarConfiguration(Configuration config) {
        super(config);
    }

    public Map<String, String> getProperties(ConfigOption<Map<String, String>> option) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.contains(option)) {
            Map map = (Map)this.get(option);
            properties.putAll(map);
        }
        String prefix = option.key() + ".";
        List keys = this.keySet().stream().filter(key -> key.startsWith(prefix) && key.length() > prefix.length()).collect(Collectors.toList());
        for (String key2 : keys) {
            ConfigOption o = ConfigOptions.key((String)key2).stringType().noDefaultValue();
            String value = (String)this.get(o);
            properties.put(key2.substring(prefix.length()), value);
        }
        return properties;
    }

    public <F, T> T get(ConfigOption<F> option, Function<F, T> convertor) {
        Object value = this.get(option);
        if (value != null) {
            return convertor.apply(value);
        }
        return null;
    }

    public <T> void useOption(ConfigOption<T> option, Consumer<T> setter) {
        this.useOption(option, Function.identity(), setter);
    }

    public <T, V> void useOption(ConfigOption<T> option, Function<T, V> convertor, Consumer<V> setter) {
        if (this.contains(option) || option.hasDefaultValue()) {
            V value = this.get(option, convertor);
            setter.accept(value);
        }
    }
}

