/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Optional;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.avro.Schema;

public class NativeAvroBytesSchema<T>
implements org.apache.pulsar.client.api.Schema<byte[]> {
    private org.apache.pulsar.client.api.Schema<T> schema;
    private Schema nativeSchema;

    public NativeAvroBytesSchema(Schema schema) {
        this.setSchema(schema);
    }

    public NativeAvroBytesSchema(Object schema) {
        this(NativeAvroBytesSchema.validateSchema(schema));
    }

    public void setSchema(Schema schema) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withJsonDef(schema.toString(false)).build();
        this.nativeSchema = schema;
        this.schema = AvroSchema.of(schemaDefinition);
    }

    public boolean schemaInitialized() {
        return this.schema != null;
    }

    private static Schema validateSchema(Object schema) {
        if (!(schema instanceof Schema)) {
            throw new IllegalArgumentException("The input schema is not of type 'org.apache.avro.Schema'.");
        }
        return (Schema)schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(this.schemaInitialized(), "Schema is not initialized before used");
    }

    @Override
    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.nativeSchema);
    }

    @Override
    public org.apache.pulsar.client.api.Schema<byte[]> clone() {
        return new NativeAvroBytesSchema<T>(this.nativeSchema);
    }
}

