/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.PbSchemaValidator;
import org.apache.flink.formats.protobuf.serialize.RowToProtoConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(PbRowDataSerializationSchema.class);
    private final RowType rowType;
    private final String messageClassName;
    private transient RowToProtoConverter rowToProtoConverter;

    public PbRowDataSerializationSchema(RowType rowType, String messageClassName) {
        this.rowType = rowType;
        this.messageClassName = messageClassName;
        Descriptors.Descriptor descriptor = PbFormatUtils.getDescriptor(messageClassName);
        new PbSchemaValidator(descriptor, rowType).validate();
        try {
            this.rowToProtoConverter = new RowToProtoConverter(messageClassName, rowType);
        }
        catch (PbCodegenException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.rowToProtoConverter = new RowToProtoConverter(this.messageClassName, this.rowType);
    }

    public byte[] serialize(RowData element) {
        try {
            return this.rowToProtoConverter.convertRowToProtoBinary(element);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }
}

