/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenSimpleSerializer
implements PbCodegenSerializer {
    private Descriptors.FieldDescriptor fd;
    private LogicalType type;

    public PbCodegenSimpleSerializer(Descriptors.FieldDescriptor fd, LogicalType type) {
        this.fd = fd;
        this.type = type;
    }

    @Override
    public String codegen(String returnPbVar, String dataGetStr) {
        switch (this.type.getTypeRoot()) {
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return returnPbVar + " = " + dataGetStr + ";";
            }
            case VARCHAR: 
            case CHAR: {
                PbCodegenAppender appender = new PbCodegenAppender();
                int uid = PbCodegenVarId.getInstance().getAndIncrement();
                String fromVar = "fromVar" + uid;
                appender.appendLine("String " + fromVar);
                appender.appendLine(fromVar + " = " + dataGetStr + ".toString()");
                if (this.fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                    String enumValueDescVar = "enumValueDesc" + uid;
                    String enumTypeStr = PbFormatUtils.getFullJavaName(this.fd.getEnumType());
                    appender.appendLine("Descriptors.EnumValueDescriptor " + enumValueDescVar + "=" + enumTypeStr + ".getDescriptor().findValueByName(" + fromVar + ")");
                    appender.appendSegment("if(null == " + enumValueDescVar + "){");
                    appender.appendLine(returnPbVar + " = " + enumTypeStr + ".values()[0]");
                    appender.appendSegment("}");
                    appender.appendSegment("else{");
                    appender.appendLine(returnPbVar + " = " + enumTypeStr + ".valueOf(" + enumValueDescVar + ")");
                    appender.appendLine("}");
                } else {
                    appender.appendLine(returnPbVar + " = " + fromVar);
                }
                return appender.code();
            }
            case VARBINARY: 
            case BINARY: {
                return returnPbVar + " = ByteString.copyFrom(" + dataGetStr + ");";
            }
        }
        throw new IllegalArgumentException("Unsupported data type in schema: " + this.type);
    }
}

