/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.RowType;
import org.codehaus.janino.ScriptEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoToRowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoToRowConverter.class);
    private ScriptEvaluator se;
    private Method parseFromMethod;

    public ProtoToRowConverter(String messageClassName, RowType rowType, boolean readDefaultValues) throws PbCodegenException {
        try {
            Descriptors.Descriptor descriptor = PbFormatUtils.getDescriptor(messageClassName);
            Class<?> messageClass = Class.forName(messageClassName);
            if (descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                readDefaultValues = true;
            }
            this.se = new ScriptEvaluator();
            this.se.setParameters(new String[]{"message"}, new Class[]{messageClass});
            this.se.setReturnType(RowData.class);
            this.se.setDefaultImports(new String[]{RowData.class.getName(), ArrayData.class.getName(), BinaryStringData.class.getName(), GenericRowData.class.getName(), GenericMapData.class.getName(), GenericArrayData.class.getName(), ArrayList.class.getName(), List.class.getName(), Map.class.getName(), HashMap.class.getName()});
            PbCodegenAppender codegenAppender = new PbCodegenAppender();
            codegenAppender.appendLine("RowData rowData=null");
            PbCodegenDeserializer codegenDes = PbCodegenDeserializeFactory.getPbCodegenTopRowDes(descriptor, rowType, readDefaultValues);
            String genCode = codegenDes.codegen("rowData", "message");
            codegenAppender.appendSegment(genCode);
            codegenAppender.appendLine("return rowData");
            String printCode = codegenAppender.printWithLineNumber();
            LOG.debug("Protobuf decode codegen: \n" + printCode);
            this.se.cook(codegenAppender.code());
            this.parseFromMethod = messageClass.getMethod("parseFrom", byte[].class);
        }
        catch (Exception ex) {
            throw new PbCodegenException(ex);
        }
    }

    public RowData convertProtoBinaryToRow(byte[] data) throws Exception {
        Object messageObj = this.parseFromMethod.invoke(null, new Object[]{data});
        return (RowData)this.se.evaluate(new Object[]{messageObj});
    }
}

