/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import java.util.List;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenRowDeserializer
implements PbCodegenDeserializer {
    private List<Descriptors.FieldDescriptor> fds;
    private Descriptors.Descriptor descriptor;
    private RowType rowType;
    private boolean readDefaultValues;
    private PbCodegenAppender appender = new PbCodegenAppender();

    public PbCodegenRowDeserializer(Descriptors.Descriptor descriptor, RowType rowType, boolean readDefaultValues) {
        this.fds = descriptor.getFields();
        this.rowType = rowType;
        this.descriptor = descriptor;
        this.readDefaultValues = readDefaultValues;
    }

    @Override
    public String codegen(String returnVarName, String messageGetStr) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        String pbMessageVar = "message" + uid;
        String rowDataVar = "rowData" + uid;
        int fieldSize = this.rowType.getFieldNames().size();
        String pbMessageTypeStr = PbFormatUtils.getFullJavaName(this.descriptor);
        this.appender.appendLine(pbMessageTypeStr + " " + pbMessageVar + " = " + messageGetStr);
        this.appender.appendLine("GenericRowData " + rowDataVar + " = new GenericRowData(" + fieldSize + ")");
        int index = 0;
        for (String fieldName : this.rowType.getFieldNames()) {
            int subUid = varUid.getAndIncrement();
            String elementDataVar = "elementDataVar" + subUid;
            LogicalType subType = this.rowType.getTypeAt(this.rowType.getFieldIndex(fieldName));
            Descriptors.FieldDescriptor elementFd = this.descriptor.findFieldByName(fieldName);
            String strongCamelFieldName = PbFormatUtils.getStrongCamelCaseJsonName(fieldName);
            PbCodegenDeserializer codegen = PbCodegenDeserializeFactory.getPbCodegenDes(elementFd, subType, this.readDefaultValues);
            this.appender.appendLine("Object " + elementDataVar + " = null");
            if (!this.readDefaultValues) {
                String isMessageNonEmptyStr = this.isMessageNonEmptyStr(pbMessageVar, strongCamelFieldName, elementFd);
                this.appender.appendSegment("if(" + isMessageNonEmptyStr + "){");
            }
            String elementMessageGetStr = this.pbMessageElementGetStr(pbMessageVar, strongCamelFieldName, elementFd);
            if (!elementFd.isRepeated()) {
                switch (elementFd.getJavaType()) {
                    case INT: {
                        elementMessageGetStr = "Integer.valueOf(" + elementMessageGetStr + ")";
                        break;
                    }
                    case LONG: {
                        elementMessageGetStr = "Long.valueOf(" + elementMessageGetStr + ")";
                        break;
                    }
                    case FLOAT: {
                        elementMessageGetStr = "Float.valueOf(" + elementMessageGetStr + ")";
                        break;
                    }
                    case DOUBLE: {
                        elementMessageGetStr = "Double.valueOf(" + elementMessageGetStr + ")";
                        break;
                    }
                    case BOOLEAN: {
                        elementMessageGetStr = "Boolean.valueOf(" + elementMessageGetStr + ")";
                    }
                }
            }
            String code = codegen.codegen(elementDataVar, elementMessageGetStr);
            this.appender.appendSegment(code);
            if (!this.readDefaultValues) {
                this.appender.appendSegment("}");
            }
            this.appender.appendLine(rowDataVar + ".setField(" + index + ", " + elementDataVar + ")");
            ++index;
        }
        this.appender.appendLine(returnVarName + " = " + rowDataVar);
        return this.appender.code();
    }

    private String pbMessageElementGetStr(String message, String fieldName, Descriptors.FieldDescriptor fd) {
        if (fd.isMapField()) {
            return message + ".get" + fieldName + "Map()";
        }
        if (fd.isRepeated()) {
            return message + ".get" + fieldName + "List()";
        }
        return message + ".get" + fieldName + "()";
    }

    private String isMessageNonEmptyStr(String message, String fieldName, Descriptors.FieldDescriptor fd) {
        if (fd.isRepeated()) {
            return message + ".get" + fieldName + "Count() > 0";
        }
        return message + ".has" + fieldName + "()";
    }
}

