/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenUtils;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbCodegenMapDeserializer
implements PbCodegenDeserializer {
    private Descriptors.FieldDescriptor fd;
    private MapType mapType;
    private boolean readDefaultValues;

    public PbCodegenMapDeserializer(Descriptors.FieldDescriptor fd, MapType mapType, boolean readDefaultValues) {
        this.fd = fd;
        this.mapType = mapType;
        this.readDefaultValues = readDefaultValues;
    }

    @Override
    public String codegen(String returnVarName, String messageGetStr) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        LogicalType keyType = this.mapType.getKeyType();
        LogicalType valueType = this.mapType.getValueType();
        Descriptors.FieldDescriptor keyFd = this.fd.getMessageType().findFieldByName("key");
        Descriptors.FieldDescriptor valueFd = this.fd.getMessageType().findFieldByName("value");
        PbCodegenAppender appender = new PbCodegenAppender();
        String pbKeyTypeStr = PbCodegenUtils.getTypeStrFromProto(keyFd, false);
        String pbValueTypeStr = PbCodegenUtils.getTypeStrFromProto(valueFd, false);
        String pbMapVar = "pbMap" + uid;
        String pbMapEntryVar = "pbEntry" + uid;
        String resultDataMapVar = "resultDataMap" + uid;
        String keyDataVar = "keyDataVar" + uid;
        String valueDataVar = "valueDataVar" + uid;
        appender.appendLine("Map<" + pbKeyTypeStr + "," + pbValueTypeStr + "> " + pbMapVar + " = " + messageGetStr + ";");
        appender.appendLine("Map " + resultDataMapVar + " = new HashMap()");
        appender.appendSegment("for(Map.Entry<" + pbKeyTypeStr + "," + pbValueTypeStr + "> " + pbMapEntryVar + ": " + pbMapVar + ".entrySet()){");
        appender.appendLine("Object " + keyDataVar + "= null");
        appender.appendLine("Object " + valueDataVar + "= null");
        PbCodegenDeserializer keyDes = PbCodegenDeserializeFactory.getPbCodegenDes(keyFd, keyType, this.readDefaultValues);
        PbCodegenDeserializer valueDes = PbCodegenDeserializeFactory.getPbCodegenDes(valueFd, valueType, this.readDefaultValues);
        String keyGenCode = keyDes.codegen(keyDataVar, "((" + pbKeyTypeStr + ")" + pbMapEntryVar + ".getKey())");
        appender.appendSegment(keyGenCode);
        String valueGenCode = valueDes.codegen(valueDataVar, "((" + pbValueTypeStr + ")" + pbMapEntryVar + ".getValue())");
        appender.appendSegment(valueGenCode);
        appender.appendLine(resultDataMapVar + ".put(" + keyDataVar + ", " + valueDataVar + ")");
        appender.appendSegment("}");
        appender.appendLine(returnVarName + " = new GenericMapData(" + resultDataMapVar + ")");
        return appender.code();
    }
}

