/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import com.google.protobuf.Descriptors;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;

public class PbRowTypeInformation {
    public static RowType generateRowType(Descriptors.Descriptor root) {
        int size = root.getFields().size();
        LogicalType[] types = new LogicalType[size];
        String[] rowFieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)root.getFields().get(i);
            rowFieldNames[i] = field.getName();
            types[i] = PbRowTypeInformation.generateFieldTypeInformation(field);
        }
        return RowType.of((LogicalType[])types, (String[])rowFieldNames);
    }

    public static LogicalType generateFieldTypeInformation(Descriptors.FieldDescriptor field) {
        VarCharType type;
        Descriptors.FieldDescriptor.JavaType fieldType = field.getJavaType();
        if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
            if (field.isMapField()) {
                MapType mapType = new MapType(PbRowTypeInformation.generateFieldTypeInformation(field.getMessageType().findFieldByName("key")), PbRowTypeInformation.generateFieldTypeInformation(field.getMessageType().findFieldByName("value")));
                return mapType;
            }
            if (field.isRepeated()) {
                return new ArrayType((LogicalType)PbRowTypeInformation.generateRowType(field.getMessageType()));
            }
            return PbRowTypeInformation.generateRowType(field.getMessageType());
        }
        if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.STRING)) {
            type = new VarCharType(Integer.MAX_VALUE);
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.LONG)) {
            type = new BigIntType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.BOOLEAN)) {
            type = new BooleanType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.INT)) {
            type = new IntType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.DOUBLE)) {
            type = new DoubleType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.FLOAT)) {
            type = new FloatType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
            type = new VarCharType(Integer.MAX_VALUE);
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
            type = new VarBinaryType(Integer.MAX_VALUE);
        } else {
            throw new ValidationException("unsupported field type: " + fieldType);
        }
        if (field.isRepeated()) {
            return new ArrayType((LogicalType)type);
        }
        return type;
    }
}

