/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import com.google.protobuf.Descriptors;
import org.apache.flink.table.types.logical.LogicalType;

public class PbFormatUtils {
    public static String fieldNameToJsonName(String name) {
        int length = name.length();
        StringBuilder result = new StringBuilder(length);
        boolean isNextUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch == '_') {
                isNextUpperCase = true;
                continue;
            }
            if (isNextUpperCase) {
                if ('a' <= ch && ch <= 'z') {
                    ch = (char)(ch - 97 + 65);
                    isNextUpperCase = false;
                }
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static boolean isSimpleType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return true;
            }
        }
        return false;
    }

    public static String getStrongCamelCaseJsonName(String name) {
        String jsonName = PbFormatUtils.fieldNameToJsonName(name);
        if (jsonName.length() == 1) {
            return jsonName.toUpperCase();
        }
        return jsonName.substring(0, 1).toUpperCase() + jsonName.substring(1);
    }

    public static Descriptors.Descriptor getDescriptor(String className) {
        try {
            Class<?> pbClass = Class.forName(className);
            return (Descriptors.Descriptor)pbClass.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception y) {
            throw new IllegalArgumentException(String.format("get %s descriptors error!", className), y);
        }
    }

    public static String getFullJavaName(Descriptors.Descriptor descriptor) {
        if (null != descriptor.getContainingType()) {
            return PbFormatUtils.getFullJavaName(descriptor.getContainingType()) + "." + descriptor.getName();
        }
        return descriptor.getFullName();
    }

    public static String getFullJavaName(Descriptors.EnumDescriptor enumDescriptor) {
        if (null != enumDescriptor.getContainingType()) {
            return PbFormatUtils.getFullJavaName(enumDescriptor.getContainingType()) + "." + enumDescriptor.getName();
        }
        return enumDescriptor.getFullName();
    }
}

