/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.sink;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessageBuilder;
import org.apache.flink.connector.pulsar.table.sink.PulsarTableSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.bouncycastle.util.Arrays;

public class PulsarWritableMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> writableMetadataKeys;
    private final int physicalChildrenSize;
    private final int[] metadataPositions;

    public PulsarWritableMetadata(List<String> writableMetadataKeys, int physicalChildrenSize) {
        this.writableMetadataKeys = writableMetadataKeys;
        this.physicalChildrenSize = physicalChildrenSize;
        this.metadataPositions = this.getMetadataPositions();
    }

    public void applyWritableMetadataInMessage(RowData consumedRow, PulsarMessageBuilder<byte[]> messageBuilder) {
        Long eventTime;
        Map properties = (Map)this.readMetadata(consumedRow, WritableMetadata.PROPERTIES);
        if (properties != null) {
            messageBuilder.properties(properties);
        }
        if ((eventTime = (Long)this.readMetadata(consumedRow, WritableMetadata.EVENT_TIME)) != null && eventTime > 0L) {
            messageBuilder.eventTime(eventTime);
        }
    }

    private <T> T readMetadata(RowData consumedRow, WritableMetadata metadata) {
        if (Arrays.isNullOrEmpty((int[])this.metadataPositions)) {
            return null;
        }
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }

    private int[] getMetadataPositions() {
        return Stream.of(WritableMetadata.values()).mapToInt(m -> {
            int pos = this.writableMetadataKeys.indexOf(m.key);
            if (pos < 0) {
                return -1;
            }
            return this.physicalChildrenSize + pos;
        }).toArray();
    }

    public static enum WritableMetadata {
        PROPERTIES("properties", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), (row, pos) -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            MapData map = row.getMap(pos);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            Properties properties = new Properties();
            for (int i = 0; i < keyArray.size(); ++i) {
                if (keyArray.isNullAt(i) || valueArray.isNullAt(i)) continue;
                String key = keyArray.getString(i).toString();
                String value = valueArray.getString(i).toString();
                properties.put(key, value);
            }
            return properties;
        }),
        EVENT_TIME("event_time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), (row, pos) -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            return row.getTimestamp(pos, 3).getMillisecond();
        });

        public final String key;
        public final DataType dataType;
        public final PulsarTableSerializationSchema.MetadataConverter converter;

        private WritableMetadata(String key, DataType dataType, PulsarTableSerializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

