/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table;

import java.time.Duration;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.pulsar.client.api.SubscriptionType;

@PublicEvolving
public final class PulsarTableOptions {
    public static final ConfigOption<List<String>> TOPICS = ConfigOptions.key((String)"topics").stringType().asList().noDefaultValue().withDescription(Description.builder().text("Topic name(s) the table reads data from. It can be a single topic name or a list of topic names separated by a semicolon symbol (%s) like %s. When a list of topics configured, please ensure that all the topics are in the same schema as Flink Table need a fixed schema.", new InlineElement[]{TextElement.code((String)";"), TextElement.code((String)"topic-1;topic-2")}).build());
    public static final ConfigOption<SubscriptionType> SOURCE_SUBSCRIPTION_TYPE = ConfigOptions.key((String)"source.subscription-type").enumType(SubscriptionType.class).defaultValue((Object)SubscriptionType.Exclusive).withDescription(Description.builder().text("The [subscription type](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-subscriptions) that is supported by the [Pulsar DataStream source connector](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-source). Currently, only %s and %s subscription types are supported.", new InlineElement[]{TextElement.code((String)"Exclusive"), TextElement.code((String)"Shared")}).build());
    public static final ConfigOption<String> SOURCE_SUBSCRIPTION_NAME = ConfigOptions.key((String)"source.subscription-name").stringType().noDefaultValue().withDescription(Description.builder().text("The subscription name of the consumer that is used by the runtime [Pulsar DataStream source connector](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-source). This argument is required for constructing the consumer.").build());
    public static final ConfigOption<String> SOURCE_START_FROM_MESSAGE_ID = ConfigOptions.key((String)"source.start.message-id").stringType().noDefaultValue().withDescription(Description.builder().text("(Optional) Message id that is used to specify a consuming starting point for source. Use %s, %s or pass in a message id representation in %s, such as %s. This option takes precedence over source.start.publish-time.", new InlineElement[]{TextElement.code((String)"earliest"), TextElement.code((String)"latest"), TextElement.code((String)"ledgerId:entryId:partitionId"), TextElement.code((String)"12:2:-1")}).build());
    public static final ConfigOption<Long> SOURCE_START_FROM_PUBLISH_TIME = ConfigOptions.key((String)"source.start.publish-time").longType().noDefaultValue().withDescription(Description.builder().text("(Optional) Publish timestamp that is used to specify a starting point for the [Pulsar DataStream source connector](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-source) to consume data. Option source.start.message-id takes precedence over this one.").build());
    public static final ConfigOption<String> SOURCE_STOP_AT_MESSAGE_ID = ConfigOptions.key((String)"source.stop.at-message-id").stringType().noDefaultValue().withDescription("Optional message id used to specify a stop cursor for the unbounded sql source. Use \"never\", \"latest\" or pass in a message id representation in \"ledgerId:entryId:partitionId\", such as \"12:2:-1\"");
    public static final ConfigOption<String> SOURCE_STOP_AFTER_MESSAGE_ID = ConfigOptions.key((String)"source.stop.after-message-id").stringType().noDefaultValue().withDescription("Optional message id used to specify a stop position but include the given message in the consuming result for the unbounded sql source. Pass in a message id representation in \"ledgerId:entryId:partitionId\", such as \"12:2:-1\". ");
    public static final ConfigOption<Long> SOURCE_STOP_AT_PUBLISH_TIME = ConfigOptions.key((String)"source.stop.at-publish-time").longType().noDefaultValue().withDescription("Optional publish timestamp used to specify a stop cursor for the unbounded sql source.");
    public static final ConfigOption<String> SINK_CUSTOM_TOPIC_ROUTER = ConfigOptions.key((String)"sink.custom-topic-router").stringType().noDefaultValue().withDescription(Description.builder().text("(Optional) the custom topic router class URL that is used in the [Pulsar DataStream sink connector](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-sink). If this option is provided, the %s option will be ignored.", new InlineElement[]{TextElement.code((String)"sink.topic-routing-mode")}).build());
    public static final ConfigOption<TopicRoutingMode> SINK_TOPIC_ROUTING_MODE = ConfigOptions.key((String)"sink.topic-routing-mode").enumType(TopicRoutingMode.class).defaultValue((Object)TopicRoutingMode.ROUND_ROBIN).withDescription(Description.builder().text("(Optional) the topic routing mode. Available options are %s and %s. By default, it is set to %s. If you want to use a custom topic router, use the %s option to determine the partition for a particular message.", new InlineElement[]{TextElement.code((String)"round-robin"), TextElement.code((String)"message-key-hash"), TextElement.code((String)"round-robin"), TextElement.code((String)"sink.custom-topic-router")}).build());
    public static final ConfigOption<Duration> SINK_MESSAGE_DELAY_INTERVAL = ConfigOptions.key((String)"sink.message-delay-interval").durationType().defaultValue((Object)Duration.ZERO).withDescription("(Optional) the message delay delivery interval that is used in the [Pulsar DataStream sink connector](https://nightlies.apache.org/flink/flink-docs-master/docs/connectors/datastream/pulsar/#pulsar-sink).");
    public static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)"key.format").stringType().noDefaultValue().withDescription("Defines the format identifier for decoding/encoding key bytes in Pulsar message. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<List<String>> KEY_FIELDS = ConfigOptions.key((String)"key.fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("An explicit list of physical columns from the table schema that are decoded/encoded from the key bytes of a Pulsar message. By default, this list is empty and thus a key is undefined.");
    public static final ConfigOption<String> VALUE_FORMAT = ConfigOptions.key((String)"value.format").stringType().noDefaultValue().withDescription("Defines the format identifier for decoding/encoding value data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<String> SERVICE_URL = ConfigOptions.key((String)"service-url").stringType().noDefaultValue().withDescription(Description.builder().text("Service URL provider for Pulsar service.").linebreak().text("To connect to Pulsar using client libraries, you need to specify a Pulsar protocol URL.").linebreak().text("You can assign Pulsar protocol URLs to specific clusters and use the Pulsar scheme.").linebreak().list(new InlineElement[]{TextElement.text((String)"This is an example of %s: %s.", (InlineElement[])new InlineElement[]{TextElement.code((String)"localhost"), TextElement.code((String)"pulsar://localhost:6650")}), TextElement.text((String)"If you have multiple brokers, the URL is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://localhost:6550,localhost:6651,localhost:6652")}), TextElement.text((String)"A URL for a production Pulsar cluster is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://pulsar.us-west.example.com:6650")}), TextElement.text((String)"If you use TLS authentication, the URL is as %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar+ssl://pulsar.us-west.example.com:6651")})}).build());
    public static final ConfigOption<Boolean> EXPLICIT = ConfigOptions.key((String)"explicit").booleanType().defaultValue((Object)true).withDescription("Indicate if the table is an explicit Flink table.");

    private PulsarTableOptions() {
    }
}

