/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.deserializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

@Internal
public class PulsarDeserializationSchemaWrapper<T>
implements PulsarDeserializationSchema<T> {
    private static final long serialVersionUID = -630646912412751300L;
    private final DeserializationSchema<T> deserializationSchema;

    public PulsarDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(PulsarDeserializationSchema.PulsarInitializationContext context, SourceConfiguration configuration) throws Exception {
        this.deserializationSchema.open((DeserializationSchema.InitializationContext)context);
    }

    @Override
    public void deserialize(Message<byte[]> message, Collector<T> out) throws Exception {
        byte[] bytes = message.getData();
        Object instance = this.deserializationSchema.deserialize(bytes);
        out.collect(instance);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

