/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;

@Internal
public final class TopicNameUtils {
    private static final Pattern HEARTBEAT_NAMESPACE_PATTERN = Pattern.compile("pulsar/[^/]+/([^:]+:\\d+)");
    private static final Pattern HEARTBEAT_NAMESPACE_PATTERN_V2 = Pattern.compile("pulsar/([^:]+:\\d+)");
    private static final Pattern SLA_NAMESPACE_PATTERN = Pattern.compile("sla-monitor/[^/]+/([^:]+:\\d+)");

    private TopicNameUtils() {
    }

    public static String topicName(String topic) {
        return TopicName.get((String)topic).getPartitionedTopicName();
    }

    public static String topicNameWithPartition(String topic, int partitionId) {
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (String)"Illegal partition id %s", (Object[])new Object[]{partitionId});
        return TopicName.get((String)topic).getPartition(partitionId).toString();
    }

    public static boolean isPartition(String topic) {
        return TopicName.get((String)topic).isPartitioned();
    }

    public static List<String> distinctTopics(List<String> topics) {
        HashSet<String> fullTopics = new HashSet<String>();
        HashMap<String, Set> partitionedTopics = new HashMap<String, Set>();
        for (String topic : topics) {
            TopicName topicName = TopicName.get((String)topic);
            String partitionedTopicName = topicName.getPartitionedTopicName();
            if (!topicName.isPartitioned()) {
                fullTopics.add(partitionedTopicName);
                partitionedTopics.remove(partitionedTopicName);
                continue;
            }
            if (fullTopics.contains(partitionedTopicName)) continue;
            Set partitionIds = partitionedTopics.computeIfAbsent(partitionedTopicName, k -> new HashSet());
            partitionIds.add(topicName.getPartitionIndex());
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(fullTopics);
        for (Map.Entry topicSet : partitionedTopics.entrySet()) {
            String topicName = (String)topicSet.getKey();
            for (Integer partitionId : (Set)topicSet.getValue()) {
                builder.add((Object)TopicNameUtils.topicNameWithPartition(topicName, partitionId));
            }
        }
        return builder.build();
    }

    public static boolean isInternal(String topic) {
        String topicName = TopicNameUtils.topicName(topic);
        TopicName topicInstance = TopicName.get((String)topicName);
        String namespace = topicInstance.getNamespace();
        return TopicNameUtils.isSystemServiceNamespace(namespace) || SystemTopicNames.isSystemTopic((TopicName)topicInstance);
    }

    private static boolean isSystemServiceNamespace(String namespace) {
        return namespace.equals(NamespaceName.SYSTEM_NAMESPACE.toString()) || SLA_NAMESPACE_PATTERN.matcher(namespace).matches() || HEARTBEAT_NAMESPACE_PATTERN.matcher(namespace).matches() || HEARTBEAT_NAMESPACE_PATTERN_V2.matcher(namespace).matches();
    }
}

