/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.config;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.config.CursorVerification;
import org.apache.pulsar.client.api.SubscriptionMode;

@PublicEvolving
public class SourceConfiguration
extends PulsarConfiguration {
    private static final long serialVersionUID = 8488507275800787580L;
    private final int messageQueueCapacity = this.getInteger(SourceReaderOptions.ELEMENT_QUEUE_CAPACITY);
    private final long partitionDiscoveryIntervalMs = (Long)this.get(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS);
    private final boolean enableAutoAcknowledgeMessage = (Boolean)this.get(PulsarSourceOptions.PULSAR_ENABLE_AUTO_ACKNOWLEDGE_MESSAGE);
    private final long autoCommitCursorInterval = (Long)this.get(PulsarSourceOptions.PULSAR_AUTO_COMMIT_CURSOR_INTERVAL);
    private final int fetchOneMessageTime = this.getOptional(PulsarSourceOptions.PULSAR_FETCH_ONE_MESSAGE_TIME).orElse(0);
    private final Duration maxFetchTime = this.get(PulsarSourceOptions.PULSAR_MAX_FETCH_TIME, Duration::ofMillis);
    private final int maxFetchRecords = (Integer)this.get(PulsarSourceOptions.PULSAR_MAX_FETCH_RECORDS);
    private final CursorVerification verifyInitialOffsets = (CursorVerification)((Object)this.get(PulsarSourceOptions.PULSAR_VERIFY_INITIAL_OFFSETS));
    private final String subscriptionName = (String)this.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME);
    private final SubscriptionMode subscriptionMode = (SubscriptionMode)this.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_MODE);
    private final boolean allowKeySharedOutOfOrderDelivery = (Boolean)this.get(PulsarSourceOptions.PULSAR_ALLOW_KEY_SHARED_OUT_OF_ORDER_DELIVERY);
    private final boolean enableSchemaEvolution = (Boolean)this.get(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION);
    private final boolean enableMetrics = (Boolean)this.get(PulsarSourceOptions.PULSAR_ENABLE_SOURCE_METRICS) != false && (Long)this.get(PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS) > 0L;
    private final boolean resetSubscriptionCursor = (Boolean)this.get(PulsarSourceOptions.PULSAR_RESET_SUBSCRIPTION_CURSOR);

    public SourceConfiguration(Configuration configuration) {
        super(configuration);
    }

    public int getMessageQueueCapacity() {
        return this.messageQueueCapacity;
    }

    public boolean isEnablePartitionDiscovery() {
        return this.getPartitionDiscoveryIntervalMs() > 0L;
    }

    public long getPartitionDiscoveryIntervalMs() {
        return this.partitionDiscoveryIntervalMs;
    }

    public boolean isEnableAutoAcknowledgeMessage() {
        return this.enableAutoAcknowledgeMessage;
    }

    public long getAutoCommitCursorInterval() {
        return this.autoCommitCursorInterval;
    }

    public int getFetchOneMessageTime() {
        return this.fetchOneMessageTime;
    }

    public Duration getMaxFetchTime() {
        return this.maxFetchTime;
    }

    public int getMaxFetchRecords() {
        return this.maxFetchRecords;
    }

    public CursorVerification getVerifyInitialOffsets() {
        return this.verifyInitialOffsets;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public boolean isAllowKeySharedOutOfOrderDelivery() {
        return this.allowKeySharedOutOfOrderDelivery;
    }

    public boolean isEnableSchemaEvolution() {
        return this.enableSchemaEvolution;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public boolean isResetSubscriptionCursor() {
        return this.resetSubscriptionCursor;
    }

    public String getSubscriptionDesc() {
        return this.getSubscriptionName() + "(Exclusive," + this.getSubscriptionMode() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceConfiguration that = (SourceConfiguration)((Object)o);
        return this.messageQueueCapacity == that.messageQueueCapacity && this.partitionDiscoveryIntervalMs == that.partitionDiscoveryIntervalMs && this.enableAutoAcknowledgeMessage == that.enableAutoAcknowledgeMessage && this.autoCommitCursorInterval == that.autoCommitCursorInterval && this.fetchOneMessageTime == that.fetchOneMessageTime && Objects.equals(this.maxFetchTime, that.maxFetchTime) && this.maxFetchRecords == that.maxFetchRecords && this.verifyInitialOffsets == that.verifyInitialOffsets && Objects.equals(this.subscriptionName, that.subscriptionName) && this.subscriptionMode == that.subscriptionMode && this.allowKeySharedOutOfOrderDelivery == that.allowKeySharedOutOfOrderDelivery && this.enableSchemaEvolution == that.enableSchemaEvolution && this.enableMetrics == that.enableMetrics && this.resetSubscriptionCursor == that.resetSubscriptionCursor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.messageQueueCapacity, this.partitionDiscoveryIntervalMs, this.enableAutoAcknowledgeMessage, this.autoCommitCursorInterval, this.fetchOneMessageTime, this.maxFetchTime, this.maxFetchRecords, this.verifyInitialOffsets, this.subscriptionName, this.subscriptionMode, this.allowKeySharedOutOfOrderDelivery, this.enableSchemaEvolution, this.enableMetrics, this.resetSubscriptionCursor});
    }
}

